<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'landlord_task',

    /*
     * Modules.
     */
    'modules'   => ['landlord_tasks'],

    
    'landlord_tasks'       => [
        'model' => [
            'model'                 => \Litecms\LandlordTask\Models\LandlordTasks::class,
            'table'                 => 'landlord_tasks',
            'presenter'             => \Litecms\LandlordTask\Repositories\Presenter\LandlordTasksPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['service',  'status'],
            'translatables'         => [],
            'upload_folder'         => 'landlord_task/landlord_tasks',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'LandlordTask',
            'module'    => 'LandlordTasks',
        ],

    ],
];
