<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateLandlordTasksTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: landlord_tasks
         */
        Schema::create('landlord_tasks', function ($table) {
            $table->increments('id');
            $table->string('service', 255)->nullable();
            $table->enum('status', ['Active','Inactive'])->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('landlord_tasks');
    }
}
