<?php

namespace Litecms\LandlordTask\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Litecms\LandlordTask\Interfaces\LandlordTasksRepositoryInterface;

class LandlordTasksPublicController extends BaseController
{
    // use LandlordTasksWorkflow;

    /**
     * Constructor.
     *
     * @param type \Litecms\LandlordTasks\Interfaces\LandlordTasksRepositoryInterface $landlord_tasks
     *
     * @return type
     */
    public function __construct(LandlordTasksRepositoryInterface $landlord_tasks)
    {
        $this->repository = $landlord_tasks;
        parent::__construct();
    }

    /**
     * Show landlord_tasks's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $landlord_tasks = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$landlord_task::$landlord_tasks.names'))
            ->view('$landlord_task::public.landlord_tasks.index')
            ->data(compact('$landlord_tasks'))
            ->output();
    }

    /**
     * Show landlord_tasks's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $landlord_tasks = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$landlord_task::$landlord_tasks.names'))
            ->view('$landlord_task::public.landlord_tasks.index')
            ->data(compact('$landlord_tasks'))
            ->output();
    }

    /**
     * Show landlord_tasks.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $landlord_tasks = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$landlord_tasks->name . trans('$landlord_task::$landlord_tasks.name'))
            ->view('$landlord_task::public.landlord_tasks.show')
            ->data(compact('$landlord_tasks'))
            ->output();
    }

}
