<?php

namespace Litecms\LandlordTask\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\LandlordTask\Http\Requests\LandlordTasksRequest;
use Litecms\LandlordTask\Interfaces\LandlordTasksRepositoryInterface;
use Litecms\LandlordTask\Models\LandlordTasks;

/**
 * Resource controller class for landlord_tasks.
 */
class LandlordTasksResourceController extends BaseController
{

    /**
     * Initialize landlord_tasks resource controller.
     *
     * @param type LandlordTasksRepositoryInterface $landlord_tasks
     *
     * @return null
     */
    public function __construct(LandlordTasksRepositoryInterface $landlord_tasks)
    {
        parent::__construct();
        $this->repository = $landlord_tasks;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\LandlordTask\Repositories\Criteria\LandlordTasksResourceCriteria::class);
    }

    /**
     * Display a list of landlord_tasks.
     *
     * @return Response
     */
    public function index(LandlordTasksRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\LandlordTask\Repositories\Presenter\LandlordTasksPresenter::class)
                ->$function();
        }

        $landlord_tasks = $this->repository->paginate();

        return $this->response->title(trans('landlord_task::landlord_tasks.names'))
            ->view('landlord_task::landlord_tasks.index', true)
            ->data(compact('landlord_tasks'))
            ->output();
    }

    /**
     * Display landlord_tasks.
     *
     * @param Request $request
     * @param Model   $landlord_tasks
     *
     * @return Response
     */
    public function show(LandlordTasksRequest $request, LandlordTasks $landlord_tasks)
    {

        if ($landlord_tasks->exists) {
            $view = 'landlord_task::landlord_tasks.show';
        } else {
            $view = 'landlord_task::landlord_tasks.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('landlord_task::landlord_tasks.name'))
            ->data(compact('landlord_tasks'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new landlord_tasks.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(LandlordTasksRequest $request)
    {

        $landlord_tasks = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('landlord_task::landlord_tasks.name')) 
            ->view('landlord_task::landlord_tasks.create', true) 
            ->data(compact('landlord_tasks'))
            ->output();
    }

    /**
     * Create new landlord_tasks.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(LandlordTasksRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $landlord_tasks                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('landlord_task::landlord_tasks.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('landlord_task/landlord_tasks/' . $landlord_tasks->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/landlord_task/landlord_tasks'))
                ->redirect();
        }

    }

    /**
     * Show landlord_tasks for editing.
     *
     * @param Request $request
     * @param Model   $landlord_tasks
     *
     * @return Response
     */
    public function edit(LandlordTasksRequest $request, LandlordTasks $landlord_tasks)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('landlord_task::landlord_tasks.name'))
            ->view('landlord_task::landlord_tasks.edit', true)
            ->data(compact('landlord_tasks'))
            ->output();
    }

    /**
     * Update the landlord_tasks.
     *
     * @param Request $request
     * @param Model   $landlord_tasks
     *
     * @return Response
     */
    public function update(LandlordTasksRequest $request, LandlordTasks $landlord_tasks)
    {
        try {
            $attributes = $request->all();

            $landlord_tasks->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('landlord_task::landlord_tasks.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('landlord_task/landlord_tasks/' . $landlord_tasks->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('landlord_task/landlord_tasks/' . $landlord_tasks->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the landlord_tasks.
     *
     * @param Model   $landlord_tasks
     *
     * @return Response
     */
    public function destroy(LandlordTasksRequest $request, LandlordTasks $landlord_tasks)
    {
        try {

            $landlord_tasks->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('landlord_task::landlord_tasks.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('landlord_task/landlord_tasks/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('landlord_task/landlord_tasks/' . $landlord_tasks->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple landlord_tasks.
     *
     * @param Model   $landlord_tasks
     *
     * @return Response
     */
    public function delete(LandlordTasksRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('landlord_task::landlord_tasks.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('landlord_task/landlord_tasks'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/landlord_task/landlord_tasks'))
                ->redirect();
        }

    }

    /**
     * Restore deleted landlord_tasks.
     *
     * @param Model   $landlord_tasks
     *
     * @return Response
     */
    public function restore(LandlordTasksRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('landlord_task::landlord_tasks.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/landlord_task/landlord_tasks'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/landlord_task/landlord_tasks/'))
                ->redirect();
        }

    }

}
