<?php

namespace Litecms\LandlordTask;

use User;

class LandlordTask
{
    /**
     * $landlord_tasks object.
     */
    protected $landlord_tasks;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\LandlordTask\Interfaces\LandlordTasksRepositoryInterface $landlord_tasks)
    {
        $this->landlord_tasks = $landlord_tasks;
    }

    /**
     * Returns count of landlord_task.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.landlord_tasks.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->landlord_tasks->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\LandlordTasksUserCriteria());
        }

        $landlord_tasks = $this->landlord_tasks->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('landlord_task::' . $view, compact('landlord_tasks'))->render();
    }
}
