<?php

namespace Litecms\LandlordTask\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\LandlordTask\Models\LandlordTasks;

class LandlordTasksPolicy
{

    /**
     * Determine if the given user can view the landlord_tasks.
     *
     * @param UserPolicy $user
     * @param LandlordTasks $landlord_tasks
     *
     * @return bool
     */
    public function view(UserPolicy $user, LandlordTasks $landlord_tasks)
    {
        if ($user->canDo('landlord_task.landlord_tasks.view') && $user->isAdmin()) {
            return true;
        }

        return $landlord_tasks->user_id == user_id() && $landlord_tasks->user_type == user_type();
    }

    /**
     * Determine if the given user can create a landlord_tasks.
     *
     * @param UserPolicy $user
     * @param LandlordTasks $landlord_tasks
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('landlord_task.landlord_tasks.create');
    }

    /**
     * Determine if the given user can update the given landlord_tasks.
     *
     * @param UserPolicy $user
     * @param LandlordTasks $landlord_tasks
     *
     * @return bool
     */
    public function update(UserPolicy $user, LandlordTasks $landlord_tasks)
    {
        if ($user->canDo('landlord_task.landlord_tasks.edit') && $user->isAdmin()) {
            return true;
        }

        return $landlord_tasks->user_id == user_id() && $landlord_tasks->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given landlord_tasks.
     *
     * @param UserPolicy $user
     * @param LandlordTasks $landlord_tasks
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, LandlordTasks $landlord_tasks)
    {
        return $landlord_tasks->user_id == user_id() && $landlord_tasks->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given landlord_tasks.
     *
     * @param UserPolicy $user
     * @param LandlordTasks $landlord_tasks
     *
     * @return bool
     */
    public function verify(UserPolicy $user, LandlordTasks $landlord_tasks)
    {
        if ($user->canDo('landlord_task.landlord_tasks.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given landlord_tasks.
     *
     * @param UserPolicy $user
     * @param LandlordTasks $landlord_tasks
     *
     * @return bool
     */
    public function approve(UserPolicy $user, LandlordTasks $landlord_tasks)
    {
        if ($user->canDo('landlord_task.landlord_tasks.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
