<?php

namespace Litecms\LandlordTask\Providers;

use Illuminate\Support\ServiceProvider;

class LandlordTaskServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'landlord_task');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'landlord_task');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.landlord_task', function ($app) {
            return $this->app->make('Litecms\LandlordTask\LandlordTask');
        });

                // Bind LandlordTasks to repository
        $this->app->bind(
            'Litecms\LandlordTask\Interfaces\LandlordTasksRepositoryInterface',
            \Litecms\LandlordTask\Repositories\Eloquent\LandlordTasksRepository::class
        );

        $this->app->register(\Litecms\LandlordTask\Providers\AuthServiceProvider::class);
                $this->app->register(\Litecms\LandlordTask\Providers\EventServiceProvider::class);
        
        $this->app->register(\Litecms\LandlordTask\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.landlord_task'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/landlord_task.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/landlord_task')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/landlord_task')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
