<?php

namespace Litecms\LandlordTask\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class LandlordTasksTransformer extends TransformerAbstract
{
    public function transform(\Litecms\LandlordTask\Models\LandlordTasks $landlord_tasks)
    {
        return [
            'id'                => $landlord_tasks->getRouteKey(),
            'key'               => [
                'public'    => $landlord_tasks->getPublicKey(),
                'route'     => $landlord_tasks->getRouteKey(),
            ], 
            'service'           => $landlord_tasks->service,
            'status'            => $landlord_tasks->status,
            'url'               => [
                'public'    => trans_url('landlord_task/'.$landlord_tasks->getPublicKey()),
                'user'      => guard_url('landlord_task/landlord_tasks/'.$landlord_tasks->getRouteKey()),
            ], 
            'status'            => trans('app.'.$landlord_tasks->status),
            'created_at'        => format_date($landlord_tasks->created_at),
            'updated_at'        => format_date($landlord_tasks->updated_at),
        ];
    }
}