<?php


return  
    [
        'model' => [
            'model' => \Order\Eee\Models\Order::class,
            'repository' => \Order\Eee\Repositories\Eloquent\OrderRepository::class,
            'table' => 'orders',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'company_id',  'seller_company_id',  'order_code',  'seller_id',  'user_id',  'placed_user_id',  'coupa_po_number',  'reference_no',  'internal_reference',  'item_charge_id',  'account_id',  'admin_account_id',  'supplier_account_id',  'batch_trans_id',  'trans_id',  'quote_id',  'approval_id',  'store_id',  'split_payment',  'user_payment_type',  'payment_lock',  'client_edit',  'substitute_favourite',  'substitute_coles',  'stock_notify_qty',  'buyer_company_name',  'buyer_company_trading_name',  'buyer_company_abn',  'buyer_company_phone',  'buyer_company_email',  'supplier_company_name',  'supplier_company_trading_name',  'supplier_company_abn',  'supplier_company_phone',  'supplier_company_email',  'shipping_type',  'f_name',  'l_name',  'company_name',  'deliver_to',  'state',  'country',  'sreet_address',  'suburb',  'zip_code',  'bill_address_to',  'bill_sreet_address',  'bill_suburb',  'bill_state',  'bill_country',  'bill_zip_code',  'cost_total',  'cart_total',  'margin_total',  'shipping_charge',  'shipping_tax_amount',  'subtotal',  'total',  'transaction_charge',  'admin_transaction_charge',  'client_transaction_charge',  'company_split_amount',  'client_split_amount',  'client_split_sub_total',  'company_split_sub_total',  'client_split_tax',  'company_split_tax',  'client_split_total',  'company_split_total',  'client_split_net_total',  'client_discount',  'company_discount',  'company_split_net_total',  'net_total',  'discount_total',  'coupon_discount',  'credit_balance_discount',  'amount',  'tax_percentage',  'taxable_amount',  'supplier_tax_amount',  'b2buy_tax_amount',  'b2buy_margin_amount',  'admin_fee',  'margin_label',  'commision_amount',  'paid_amount',  'refund_amount',  'refund_total_amount',  'refund_tax_amount',  'client_refund_amount',  'client_refund_tax_amount',  'client_refund_total_amount',  'company_refund_amount',  'company_refund_tax_amount',  'company_refund_total_amount',  'company_payment_mode',  'client_payment_mode',  'b2b_managed_payment',  'is_payment_term',  'payment_rule_type',  'refund_type',  'client_refund_status',  'company_refund_status',  'company_payment_status',  'client_payment_status',  'withdrawal_status',  'payment_docs',  'payment_docs_client',  'refund_docs',  'payment_reference_number',  'payment_reference_number_client',  'refund_reference_number',  'payment_status_log',  'status',  'order_status_log',  'approval_status',  'approval_log',  'order_update_log',  'review_state',  'payment_error',  'withdrawal_error',  'webhook_states',  'delivery_track_code',  'delivery_track_link',  'delivery_description',  'delivery_instructions',  'cancel_note',  'cancelled_user',  'user_type',  'settle_date',  'due_date',  'confirmed_date',  'delivery_type',  'cost_center_id',  'department_id',  'manager_role',  'loading_dock',  'forklift',  'intercom_num',  'contact_info',  'delivery_used',  'delivery_window_id',  'delivery_window_date',  'click_collect_id',  'time_slot',  'alternative_address_id',  'order_note',  'order_method',  'appointment_id',  'deleted_at',  'created_at',  'updated_at'],
            'translatables' => [],
            'upload_folder' => 'eee/order',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            "company_id" => [
                "key" => "company_id", 
                "type" => "text", 
                "label" => 'eee::order.label.company_id', 
                'sort' => true,
                'roles' => [],
            ],
            "seller_company_id" => [
                "key" => "seller_company_id", 
                "type" => "text", 
                "label" => 'eee::order.label.seller_company_id', 
                'sort' => true,
                'roles' => [],
            ],
            "order_code" => [
                "key" => "order_code", 
                "type" => "text", 
                "label" => 'eee::order.label.order_code', 
                'sort' => true,
                'roles' => [],
            ],
            "seller_id" => [
                "key" => "seller_id", 
                "type" => "text", 
                "label" => 'eee::order.label.seller_id', 
                'sort' => true,
                'roles' => [],
            ],
            "placed_user_id" => [
                "key" => "placed_user_id", 
                "type" => "text", 
                "label" => 'eee::order.label.placed_user_id', 
                'sort' => true,
                'roles' => [],
            ],
            "coupa_po_number" => [
                "key" => "coupa_po_number", 
                "type" => "text", 
                "label" => 'eee::order.label.coupa_po_number', 
                'sort' => true,
                'roles' => [],
            ],
            "reference_no" => [
                "key" => "reference_no", 
                "type" => "text", 
                "label" => 'eee::order.label.reference_no', 
                'sort' => true,
                'roles' => [],
            ],
            "internal_reference" => [
                "key" => "internal_reference", 
                "type" => "text", 
                "label" => 'eee::order.label.internal_reference', 
                'sort' => true,
                'roles' => [],
            ],
            "item_charge_id" => [
                "key" => "item_charge_id", 
                "type" => "text", 
                "label" => 'eee::order.label.item_charge_id', 
                'sort' => true,
                'roles' => [],
            ],
            "account_id" => [
                "key" => "account_id", 
                "type" => "text", 
                "label" => 'eee::order.label.account_id', 
                'sort' => true,
                'roles' => [],
            ],
            "admin_account_id" => [
                "key" => "admin_account_id", 
                "type" => "text", 
                "label" => 'eee::order.label.admin_account_id', 
                'sort' => true,
                'roles' => [],
            ],
            "supplier_account_id" => [
                "key" => "supplier_account_id", 
                "type" => "text", 
                "label" => 'eee::order.label.supplier_account_id', 
                'sort' => true,
                'roles' => [],
            ],
            "batch_trans_id" => [
                "key" => "batch_trans_id", 
                "type" => "text", 
                "label" => 'eee::order.label.batch_trans_id', 
                'sort' => true,
                'roles' => [],
            ],
            "trans_id" => [
                "key" => "trans_id", 
                "type" => "text", 
                "label" => 'eee::order.label.trans_id', 
                'sort' => true,
                'roles' => [],
            ],
            "quote_id" => [
                "key" => "quote_id", 
                "type" => "text", 
                "label" => 'eee::order.label.quote_id', 
                'sort' => true,
                'roles' => [],
            ],
            "approval_id" => [
                "key" => "approval_id", 
                "type" => "text", 
                "label" => 'eee::order.label.approval_id', 
                'sort' => true,
                'roles' => [],
            ],
            "store_id" => [
                "key" => "store_id", 
                "type" => "text", 
                "label" => 'eee::order.label.store_id', 
                'sort' => true,
                'roles' => [],
            ],
            "split_payment" => [
                "key" => "split_payment", 
                "type" => "text", 
                "label" => 'eee::order.label.split_payment', 
                'sort' => true,
                'roles' => [],
            ],
            "user_payment_type" => [
                "key" => "user_payment_type", 
                "type" => "text", 
                "label" => 'eee::order.label.user_payment_type', 
                'sort' => true,
                'roles' => [],
            ],
            "payment_lock" => [
                "key" => "payment_lock", 
                "type" => "text", 
                "label" => 'eee::order.label.payment_lock', 
                'sort' => true,
                'roles' => [],
            ],
            "client_edit" => [
                "key" => "client_edit", 
                "type" => "text", 
                "label" => 'eee::order.label.client_edit', 
                'sort' => true,
                'roles' => [],
            ],
            "substitute_favourite" => [
                "key" => "substitute_favourite", 
                "type" => "text", 
                "label" => 'eee::order.label.substitute_favourite', 
                'sort' => true,
                'roles' => [],
            ],
            "substitute_coles" => [
                "key" => "substitute_coles", 
                "type" => "text", 
                "label" => 'eee::order.label.substitute_coles', 
                'sort' => true,
                'roles' => [],
            ],
            "stock_notify_qty" => [
                "key" => "stock_notify_qty", 
                "type" => "text", 
                "label" => 'eee::order.label.stock_notify_qty', 
                'sort' => true,
                'roles' => [],
            ],
            "buyer_company_name" => [
                "key" => "buyer_company_name", 
                "type" => "text", 
                "label" => 'eee::order.label.buyer_company_name', 
                'sort' => true,
                'roles' => [],
            ],
            "buyer_company_trading_name" => [
                "key" => "buyer_company_trading_name", 
                "type" => "text", 
                "label" => 'eee::order.label.buyer_company_trading_name', 
                'sort' => true,
                'roles' => [],
            ],
            "buyer_company_abn" => [
                "key" => "buyer_company_abn", 
                "type" => "text", 
                "label" => 'eee::order.label.buyer_company_abn', 
                'sort' => true,
                'roles' => [],
            ],
            "buyer_company_phone" => [
                "key" => "buyer_company_phone", 
                "type" => "text", 
                "label" => 'eee::order.label.buyer_company_phone', 
                'sort' => true,
                'roles' => [],
            ],
            "buyer_company_email" => [
                "key" => "buyer_company_email", 
                "type" => "text", 
                "label" => 'eee::order.label.buyer_company_email', 
                'sort' => true,
                'roles' => [],
            ],
            "supplier_company_name" => [
                "key" => "supplier_company_name", 
                "type" => "text", 
                "label" => 'eee::order.label.supplier_company_name', 
                'sort' => true,
                'roles' => [],
            ],
            "supplier_company_trading_name" => [
                "key" => "supplier_company_trading_name", 
                "type" => "text", 
                "label" => 'eee::order.label.supplier_company_trading_name', 
                'sort' => true,
                'roles' => [],
            ],
            "supplier_company_abn" => [
                "key" => "supplier_company_abn", 
                "type" => "text", 
                "label" => 'eee::order.label.supplier_company_abn', 
                'sort' => true,
                'roles' => [],
            ],
            "supplier_company_phone" => [
                "key" => "supplier_company_phone", 
                "type" => "text", 
                "label" => 'eee::order.label.supplier_company_phone', 
                'sort' => true,
                'roles' => [],
            ],
            "supplier_company_email" => [
                "key" => "supplier_company_email", 
                "type" => "text", 
                "label" => 'eee::order.label.supplier_company_email', 
                'sort' => true,
                'roles' => [],
            ],
            "shipping_type" => [
                "key" => "shipping_type", 
                "type" => "text", 
                "label" => 'eee::order.label.shipping_type', 
                'sort' => true,
                'roles' => [],
            ],
            "f_name" => [
                "key" => "f_name", 
                "type" => "text", 
                "label" => 'eee::order.label.f_name', 
                'sort' => true,
                'roles' => [],
            ],
            "l_name" => [
                "key" => "l_name", 
                "type" => "text", 
                "label" => 'eee::order.label.l_name', 
                'sort' => true,
                'roles' => [],
            ],
            "company_name" => [
                "key" => "company_name", 
                "type" => "text", 
                "label" => 'eee::order.label.company_name', 
                'sort' => true,
                'roles' => [],
            ],
            "deliver_to" => [
                "key" => "deliver_to", 
                "type" => "text", 
                "label" => 'eee::order.label.deliver_to', 
                'sort' => true,
                'roles' => [],
            ],
            "state" => [
                "key" => "state", 
                "type" => "text", 
                "label" => 'eee::order.label.state', 
                'sort' => true,
                'roles' => [],
            ],
            "country" => [
                "key" => "country", 
                "type" => "text", 
                "label" => 'eee::order.label.country', 
                'sort' => true,
                'roles' => [],
            ],
            "sreet_address" => [
                "key" => "sreet_address", 
                "type" => "text", 
                "label" => 'eee::order.label.sreet_address', 
                'sort' => true,
                'roles' => [],
            ],
            "suburb" => [
                "key" => "suburb", 
                "type" => "text", 
                "label" => 'eee::order.label.suburb', 
                'sort' => true,
                'roles' => [],
            ],
            "zip_code" => [
                "key" => "zip_code", 
                "type" => "text", 
                "label" => 'eee::order.label.zip_code', 
                'sort' => true,
                'roles' => [],
            ],
            "bill_address_to" => [
                "key" => "bill_address_to", 
                "type" => "text", 
                "label" => 'eee::order.label.bill_address_to', 
                'sort' => true,
                'roles' => [],
            ],
            "bill_sreet_address" => [
                "key" => "bill_sreet_address", 
                "type" => "text", 
                "label" => 'eee::order.label.bill_sreet_address', 
                'sort' => true,
                'roles' => [],
            ],
            "bill_suburb" => [
                "key" => "bill_suburb", 
                "type" => "text", 
                "label" => 'eee::order.label.bill_suburb', 
                'sort' => true,
                'roles' => [],
            ],
            "bill_state" => [
                "key" => "bill_state", 
                "type" => "text", 
                "label" => 'eee::order.label.bill_state', 
                'sort' => true,
                'roles' => [],
            ],
            "bill_country" => [
                "key" => "bill_country", 
                "type" => "text", 
                "label" => 'eee::order.label.bill_country', 
                'sort' => true,
                'roles' => [],
            ],
            "bill_zip_code" => [
                "key" => "bill_zip_code", 
                "type" => "text", 
                "label" => 'eee::order.label.bill_zip_code', 
                'sort' => true,
                'roles' => [],
            ],
            "cost_total" => [
                "key" => "cost_total", 
                "type" => "text", 
                "label" => 'eee::order.label.cost_total', 
                'sort' => true,
                'roles' => [],
            ],
            "cart_total" => [
                "key" => "cart_total", 
                "type" => "text", 
                "label" => 'eee::order.label.cart_total', 
                'sort' => true,
                'roles' => [],
            ],
            "margin_total" => [
                "key" => "margin_total", 
                "type" => "text", 
                "label" => 'eee::order.label.margin_total', 
                'sort' => true,
                'roles' => [],
            ],
            "shipping_charge" => [
                "key" => "shipping_charge", 
                "type" => "text", 
                "label" => 'eee::order.label.shipping_charge', 
                'sort' => true,
                'roles' => [],
            ],
            "shipping_tax_amount" => [
                "key" => "shipping_tax_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.shipping_tax_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "subtotal" => [
                "key" => "subtotal", 
                "type" => "text", 
                "label" => 'eee::order.label.subtotal', 
                'sort' => true,
                'roles' => [],
            ],
            "total" => [
                "key" => "total", 
                "type" => "text", 
                "label" => 'eee::order.label.total', 
                'sort' => true,
                'roles' => [],
            ],
            "transaction_charge" => [
                "key" => "transaction_charge", 
                "type" => "text", 
                "label" => 'eee::order.label.transaction_charge', 
                'sort' => true,
                'roles' => [],
            ],
            "admin_transaction_charge" => [
                "key" => "admin_transaction_charge", 
                "type" => "text", 
                "label" => 'eee::order.label.admin_transaction_charge', 
                'sort' => true,
                'roles' => [],
            ],
            "client_transaction_charge" => [
                "key" => "client_transaction_charge", 
                "type" => "text", 
                "label" => 'eee::order.label.client_transaction_charge', 
                'sort' => true,
                'roles' => [],
            ],
            "company_split_amount" => [
                "key" => "company_split_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.company_split_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "client_split_amount" => [
                "key" => "client_split_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.client_split_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "client_split_sub_total" => [
                "key" => "client_split_sub_total", 
                "type" => "text", 
                "label" => 'eee::order.label.client_split_sub_total', 
                'sort' => true,
                'roles' => [],
            ],
            "company_split_sub_total" => [
                "key" => "company_split_sub_total", 
                "type" => "text", 
                "label" => 'eee::order.label.company_split_sub_total', 
                'sort' => true,
                'roles' => [],
            ],
            "client_split_tax" => [
                "key" => "client_split_tax", 
                "type" => "text", 
                "label" => 'eee::order.label.client_split_tax', 
                'sort' => true,
                'roles' => [],
            ],
            "company_split_tax" => [
                "key" => "company_split_tax", 
                "type" => "text", 
                "label" => 'eee::order.label.company_split_tax', 
                'sort' => true,
                'roles' => [],
            ],
            "client_split_total" => [
                "key" => "client_split_total", 
                "type" => "text", 
                "label" => 'eee::order.label.client_split_total', 
                'sort' => true,
                'roles' => [],
            ],
            "company_split_total" => [
                "key" => "company_split_total", 
                "type" => "text", 
                "label" => 'eee::order.label.company_split_total', 
                'sort' => true,
                'roles' => [],
            ],
            "client_split_net_total" => [
                "key" => "client_split_net_total", 
                "type" => "text", 
                "label" => 'eee::order.label.client_split_net_total', 
                'sort' => true,
                'roles' => [],
            ],
            "client_discount" => [
                "key" => "client_discount", 
                "type" => "text", 
                "label" => 'eee::order.label.client_discount', 
                'sort' => true,
                'roles' => [],
            ],
            "company_discount" => [
                "key" => "company_discount", 
                "type" => "text", 
                "label" => 'eee::order.label.company_discount', 
                'sort' => true,
                'roles' => [],
            ],
            "company_split_net_total" => [
                "key" => "company_split_net_total", 
                "type" => "text", 
                "label" => 'eee::order.label.company_split_net_total', 
                'sort' => true,
                'roles' => [],
            ],
            "net_total" => [
                "key" => "net_total", 
                "type" => "text", 
                "label" => 'eee::order.label.net_total', 
                'sort' => true,
                'roles' => [],
            ],
            "discount_total" => [
                "key" => "discount_total", 
                "type" => "text", 
                "label" => 'eee::order.label.discount_total', 
                'sort' => true,
                'roles' => [],
            ],
            "coupon_discount" => [
                "key" => "coupon_discount", 
                "type" => "text", 
                "label" => 'eee::order.label.coupon_discount', 
                'sort' => true,
                'roles' => [],
            ],
            "credit_balance_discount" => [
                "key" => "credit_balance_discount", 
                "type" => "text", 
                "label" => 'eee::order.label.credit_balance_discount', 
                'sort' => true,
                'roles' => [],
            ],
            "amount" => [
                "key" => "amount", 
                "type" => "text", 
                "label" => 'eee::order.label.amount', 
                'sort' => true,
                'roles' => [],
            ],
            "tax_percentage" => [
                "key" => "tax_percentage", 
                "type" => "text", 
                "label" => 'eee::order.label.tax_percentage', 
                'sort' => true,
                'roles' => [],
            ],
            "taxable_amount" => [
                "key" => "taxable_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.taxable_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "supplier_tax_amount" => [
                "key" => "supplier_tax_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.supplier_tax_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "b2buy_tax_amount" => [
                "key" => "b2buy_tax_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.b2buy_tax_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "b2buy_margin_amount" => [
                "key" => "b2buy_margin_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.b2buy_margin_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "admin_fee" => [
                "key" => "admin_fee", 
                "type" => "text", 
                "label" => 'eee::order.label.admin_fee', 
                'sort' => true,
                'roles' => [],
            ],
            "margin_label" => [
                "key" => "margin_label", 
                "type" => "text", 
                "label" => 'eee::order.label.margin_label', 
                'sort' => true,
                'roles' => [],
            ],
            "commision_amount" => [
                "key" => "commision_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.commision_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "paid_amount" => [
                "key" => "paid_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.paid_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "refund_amount" => [
                "key" => "refund_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.refund_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "refund_total_amount" => [
                "key" => "refund_total_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.refund_total_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "refund_tax_amount" => [
                "key" => "refund_tax_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.refund_tax_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "client_refund_amount" => [
                "key" => "client_refund_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.client_refund_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "client_refund_tax_amount" => [
                "key" => "client_refund_tax_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.client_refund_tax_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "client_refund_total_amount" => [
                "key" => "client_refund_total_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.client_refund_total_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "company_refund_amount" => [
                "key" => "company_refund_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.company_refund_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "company_refund_tax_amount" => [
                "key" => "company_refund_tax_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.company_refund_tax_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "company_refund_total_amount" => [
                "key" => "company_refund_total_amount", 
                "type" => "text", 
                "label" => 'eee::order.label.company_refund_total_amount', 
                'sort' => true,
                'roles' => [],
            ],
            "company_payment_mode" => [
                "key" => "company_payment_mode", 
                "type" => "text", 
                "label" => 'eee::order.label.company_payment_mode', 
                'sort' => true,
                'roles' => [],
            ],
            "client_payment_mode" => [
                "key" => "client_payment_mode", 
                "type" => "text", 
                "label" => 'eee::order.label.client_payment_mode', 
                'sort' => true,
                'roles' => [],
            ],
            "b2b_managed_payment" => [
                "key" => "b2b_managed_payment", 
                "type" => "text", 
                "label" => 'eee::order.label.b2b_managed_payment', 
                'sort' => true,
                'roles' => [],
            ],
            "is_payment_term" => [
                "key" => "is_payment_term", 
                "type" => "text", 
                "label" => 'eee::order.label.is_payment_term', 
                'sort' => true,
                'roles' => [],
            ],
            "payment_rule_type" => [
                "key" => "payment_rule_type", 
                "type" => "text", 
                "label" => 'eee::order.label.payment_rule_type', 
                'sort' => true,
                'roles' => [],
            ],
            "refund_type" => [
                "key" => "refund_type", 
                "type" => "text", 
                "label" => 'eee::order.label.refund_type', 
                'sort' => true,
                'roles' => [],
            ],
            "client_refund_status" => [
                "key" => "client_refund_status", 
                "type" => "text", 
                "label" => 'eee::order.label.client_refund_status', 
                'sort' => true,
                'roles' => [],
            ],
            "company_refund_status" => [
                "key" => "company_refund_status", 
                "type" => "text", 
                "label" => 'eee::order.label.company_refund_status', 
                'sort' => true,
                'roles' => [],
            ],
            "company_payment_status" => [
                "key" => "company_payment_status", 
                "type" => "text", 
                "label" => 'eee::order.label.company_payment_status', 
                'sort' => true,
                'roles' => [],
            ],
            "client_payment_status" => [
                "key" => "client_payment_status", 
                "type" => "text", 
                "label" => 'eee::order.label.client_payment_status', 
                'sort' => true,
                'roles' => [],
            ],
            "withdrawal_status" => [
                "key" => "withdrawal_status", 
                "type" => "text", 
                "label" => 'eee::order.label.withdrawal_status', 
                'sort' => true,
                'roles' => [],
            ],
            "payment_docs" => [
                "key" => "payment_docs", 
                "type" => "text", 
                "label" => 'eee::order.label.payment_docs', 
                'sort' => true,
                'roles' => [],
            ],
            "payment_docs_client" => [
                "key" => "payment_docs_client", 
                "type" => "text", 
                "label" => 'eee::order.label.payment_docs_client', 
                'sort' => true,
                'roles' => [],
            ],
            "refund_docs" => [
                "key" => "refund_docs", 
                "type" => "text", 
                "label" => 'eee::order.label.refund_docs', 
                'sort' => true,
                'roles' => [],
            ],
            "payment_reference_number" => [
                "key" => "payment_reference_number", 
                "type" => "text", 
                "label" => 'eee::order.label.payment_reference_number', 
                'sort' => true,
                'roles' => [],
            ],
            "payment_reference_number_client" => [
                "key" => "payment_reference_number_client", 
                "type" => "text", 
                "label" => 'eee::order.label.payment_reference_number_client', 
                'sort' => true,
                'roles' => [],
            ],
            "refund_reference_number" => [
                "key" => "refund_reference_number", 
                "type" => "text", 
                "label" => 'eee::order.label.refund_reference_number', 
                'sort' => true,
                'roles' => [],
            ],
            "payment_status_log" => [
                "key" => "payment_status_log", 
                "type" => "text", 
                "label" => 'eee::order.label.payment_status_log', 
                'sort' => true,
                'roles' => [],
            ],
            "order_status_log" => [
                "key" => "order_status_log", 
                "type" => "text", 
                "label" => 'eee::order.label.order_status_log', 
                'sort' => true,
                'roles' => [],
            ],
            "approval_status" => [
                "key" => "approval_status", 
                "type" => "text", 
                "label" => 'eee::order.label.approval_status', 
                'sort' => true,
                'roles' => [],
            ],
            "approval_log" => [
                "key" => "approval_log", 
                "type" => "text", 
                "label" => 'eee::order.label.approval_log', 
                'sort' => true,
                'roles' => [],
            ],
            "review_state" => [
                "key" => "review_state", 
                "type" => "text", 
                "label" => 'eee::order.label.review_state', 
                'sort' => true,
                'roles' => [],
            ],
            "webhook_states" => [
                "key" => "webhook_states", 
                "type" => "text", 
                "label" => 'eee::order.label.webhook_states', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_track_code" => [
                "key" => "delivery_track_code", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_track_code', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_track_link" => [
                "key" => "delivery_track_link", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_track_link', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_description" => [
                "key" => "delivery_description", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_description', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_instructions" => [
                "key" => "delivery_instructions", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_instructions', 
                'sort' => true,
                'roles' => [],
            ],
            "cancel_note" => [
                "key" => "cancel_note", 
                "type" => "text", 
                "label" => 'eee::order.label.cancel_note', 
                'sort' => true,
                'roles' => [],
            ],
            "cancelled_user" => [
                "key" => "cancelled_user", 
                "type" => "text", 
                "label" => 'eee::order.label.cancelled_user', 
                'sort' => true,
                'roles' => [],
            ],
            "settle_date" => [
                "key" => "settle_date", 
                "type" => "text", 
                "label" => 'eee::order.label.settle_date', 
                'sort' => true,
                'roles' => [],
            ],
            "due_date" => [
                "key" => "due_date", 
                "type" => "text", 
                "label" => 'eee::order.label.due_date', 
                'sort' => true,
                'roles' => [],
            ],
            "confirmed_date" => [
                "key" => "confirmed_date", 
                "type" => "text", 
                "label" => 'eee::order.label.confirmed_date', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_type" => [
                "key" => "delivery_type", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_type', 
                'sort' => true,
                'roles' => [],
            ],
            "cost_center_id" => [
                "key" => "cost_center_id", 
                "type" => "text", 
                "label" => 'eee::order.label.cost_center_id', 
                'sort' => true,
                'roles' => [],
            ],
            "department_id" => [
                "key" => "department_id", 
                "type" => "text", 
                "label" => 'eee::order.label.department_id', 
                'sort' => true,
                'roles' => [],
            ],
            "manager_role" => [
                "key" => "manager_role", 
                "type" => "text", 
                "label" => 'eee::order.label.manager_role', 
                'sort' => true,
                'roles' => [],
            ],
            "loading_dock" => [
                "key" => "loading_dock", 
                "type" => "text", 
                "label" => 'eee::order.label.loading_dock', 
                'sort' => true,
                'roles' => [],
            ],
            "forklift" => [
                "key" => "forklift", 
                "type" => "text", 
                "label" => 'eee::order.label.forklift', 
                'sort' => true,
                'roles' => [],
            ],
            "intercom_num" => [
                "key" => "intercom_num", 
                "type" => "text", 
                "label" => 'eee::order.label.intercom_num', 
                'sort' => true,
                'roles' => [],
            ],
            "contact_info" => [
                "key" => "contact_info", 
                "type" => "text", 
                "label" => 'eee::order.label.contact_info', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_used" => [
                "key" => "delivery_used", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_used', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_window_id" => [
                "key" => "delivery_window_id", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_window_id', 
                'sort' => true,
                'roles' => [],
            ],
            "delivery_window_date" => [
                "key" => "delivery_window_date", 
                "type" => "text", 
                "label" => 'eee::order.label.delivery_window_date', 
                'sort' => true,
                'roles' => [],
            ],
            "click_collect_id" => [
                "key" => "click_collect_id", 
                "type" => "text", 
                "label" => 'eee::order.label.click_collect_id', 
                'sort' => true,
                'roles' => [],
            ],
            "time_slot" => [
                "key" => "time_slot", 
                "type" => "text", 
                "label" => 'eee::order.label.time_slot', 
                'sort' => true,
                'roles' => [],
            ],
            "alternative_address_id" => [
                "key" => "alternative_address_id", 
                "type" => "text", 
                "label" => 'eee::order.label.alternative_address_id', 
                'sort' => true,
                'roles' => [],
            ],
            "order_note" => [
                "key" => "order_note", 
                "type" => "text", 
                "label" => 'eee::order.label.order_note', 
                'sort' => true,
                'roles' => [],
            ],
            "order_method" => [
                "key" => "order_method", 
                "type" => "text", 
                "label" => 'eee::order.label.order_method', 
                'sort' => true,
                'roles' => [],
            ],
            "appointment_id" => [
                "key" => "appointment_id", 
                "type" => "text", 
                "label" => 'eee::order.label.appointment_id', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            'company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.company_id',
                "placeholder" => 'eee::order.placeholder.company_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'seller_company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.seller_company_id',
                "placeholder" => 'eee::order.placeholder.seller_company_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'order_code' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.order_code',
                "placeholder" => 'eee::order.placeholder.order_code',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'seller_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.seller_id',
                "placeholder" => 'eee::order.placeholder.seller_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'placed_user_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.placed_user_id',
                "placeholder" => 'eee::order.placeholder.placed_user_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'coupa_po_number' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.coupa_po_number',
                "placeholder" => 'eee::order.placeholder.coupa_po_number',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'reference_no' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.reference_no',
                "placeholder" => 'eee::order.placeholder.reference_no',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'internal_reference' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.internal_reference',
                "placeholder" => 'eee::order.placeholder.internal_reference',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'item_charge_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.item_charge_id',
                "placeholder" => 'eee::order.placeholder.item_charge_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'account_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.account_id',
                "placeholder" => 'eee::order.placeholder.account_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'admin_account_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.admin_account_id',
                "placeholder" => 'eee::order.placeholder.admin_account_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_account_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.supplier_account_id',
                "placeholder" => 'eee::order.placeholder.supplier_account_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'batch_trans_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.batch_trans_id',
                "placeholder" => 'eee::order.placeholder.batch_trans_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'trans_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.trans_id',
                "placeholder" => 'eee::order.placeholder.trans_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'quote_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.quote_id',
                "placeholder" => 'eee::order.placeholder.quote_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'approval_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.approval_id',
                "placeholder" => 'eee::order.placeholder.approval_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'store_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.store_id',
                "placeholder" => 'eee::order.placeholder.store_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'split_payment' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.split_payment',
                "placeholder" => 'eee::order.placeholder.split_payment',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'user_payment_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.user_payment_type',
                "placeholder" => 'eee::order.placeholder.user_payment_type',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_lock' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.payment_lock',
                "placeholder" => 'eee::order.placeholder.payment_lock',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_edit' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.client_edit',
                "placeholder" => 'eee::order.placeholder.client_edit',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'substitute_favourite' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.substitute_favourite',
                "placeholder" => 'eee::order.placeholder.substitute_favourite',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'substitute_coles' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.substitute_coles',
                "placeholder" => 'eee::order.placeholder.substitute_coles',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'stock_notify_qty' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.stock_notify_qty',
                "placeholder" => 'eee::order.placeholder.stock_notify_qty',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'buyer_company_name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.buyer_company_name',
                "placeholder" => 'eee::order.placeholder.buyer_company_name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'buyer_company_trading_name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.buyer_company_trading_name',
                "placeholder" => 'eee::order.placeholder.buyer_company_trading_name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'buyer_company_abn' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.buyer_company_abn',
                "placeholder" => 'eee::order.placeholder.buyer_company_abn',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'buyer_company_phone' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.buyer_company_phone',
                "placeholder" => 'eee::order.placeholder.buyer_company_phone',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'buyer_company_email' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.buyer_company_email',
                "placeholder" => 'eee::order.placeholder.buyer_company_email',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_company_name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.supplier_company_name',
                "placeholder" => 'eee::order.placeholder.supplier_company_name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_company_trading_name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.supplier_company_trading_name',
                "placeholder" => 'eee::order.placeholder.supplier_company_trading_name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_company_abn' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.supplier_company_abn',
                "placeholder" => 'eee::order.placeholder.supplier_company_abn',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_company_phone' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.supplier_company_phone',
                "placeholder" => 'eee::order.placeholder.supplier_company_phone',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_company_email' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.supplier_company_email',
                "placeholder" => 'eee::order.placeholder.supplier_company_email',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'shipping_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.shipping_type',
                "placeholder" => 'eee::order.placeholder.shipping_type',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'f_name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.f_name',
                "placeholder" => 'eee::order.placeholder.f_name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'l_name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.l_name',
                "placeholder" => 'eee::order.placeholder.l_name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.company_name',
                "placeholder" => 'eee::order.placeholder.company_name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'deliver_to' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.deliver_to',
                "placeholder" => 'eee::order.placeholder.deliver_to',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'state' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.state',
                "placeholder" => 'eee::order.placeholder.state',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'country' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.country',
                "placeholder" => 'eee::order.placeholder.country',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'sreet_address' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.sreet_address',
                "placeholder" => 'eee::order.placeholder.sreet_address',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'suburb' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.suburb',
                "placeholder" => 'eee::order.placeholder.suburb',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'zip_code' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.zip_code',
                "placeholder" => 'eee::order.placeholder.zip_code',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'bill_address_to' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.bill_address_to',
                "placeholder" => 'eee::order.placeholder.bill_address_to',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'bill_sreet_address' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.bill_sreet_address',
                "placeholder" => 'eee::order.placeholder.bill_sreet_address',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'bill_suburb' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.bill_suburb',
                "placeholder" => 'eee::order.placeholder.bill_suburb',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'bill_state' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.bill_state',
                "placeholder" => 'eee::order.placeholder.bill_state',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'bill_country' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.bill_country',
                "placeholder" => 'eee::order.placeholder.bill_country',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'bill_zip_code' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.bill_zip_code',
                "placeholder" => 'eee::order.placeholder.bill_zip_code',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'cost_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.cost_total',
                "placeholder" => 'eee::order.placeholder.cost_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'cart_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.cart_total',
                "placeholder" => 'eee::order.placeholder.cart_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'margin_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.margin_total',
                "placeholder" => 'eee::order.placeholder.margin_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'shipping_charge' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.shipping_charge',
                "placeholder" => 'eee::order.placeholder.shipping_charge',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'shipping_tax_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.shipping_tax_amount',
                "placeholder" => 'eee::order.placeholder.shipping_tax_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'subtotal' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.subtotal',
                "placeholder" => 'eee::order.placeholder.subtotal',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.total',
                "placeholder" => 'eee::order.placeholder.total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'transaction_charge' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.transaction_charge',
                "placeholder" => 'eee::order.placeholder.transaction_charge',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'admin_transaction_charge' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.admin_transaction_charge',
                "placeholder" => 'eee::order.placeholder.admin_transaction_charge',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_transaction_charge' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_transaction_charge',
                "placeholder" => 'eee::order.placeholder.client_transaction_charge',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_split_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_split_amount',
                "placeholder" => 'eee::order.placeholder.company_split_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_split_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_split_amount',
                "placeholder" => 'eee::order.placeholder.client_split_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_split_sub_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_split_sub_total',
                "placeholder" => 'eee::order.placeholder.client_split_sub_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_split_sub_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_split_sub_total',
                "placeholder" => 'eee::order.placeholder.company_split_sub_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_split_tax' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_split_tax',
                "placeholder" => 'eee::order.placeholder.client_split_tax',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_split_tax' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_split_tax',
                "placeholder" => 'eee::order.placeholder.company_split_tax',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_split_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_split_total',
                "placeholder" => 'eee::order.placeholder.client_split_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_split_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_split_total',
                "placeholder" => 'eee::order.placeholder.company_split_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_split_net_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_split_net_total',
                "placeholder" => 'eee::order.placeholder.client_split_net_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_discount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_discount',
                "placeholder" => 'eee::order.placeholder.client_discount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_discount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_discount',
                "placeholder" => 'eee::order.placeholder.company_discount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_split_net_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_split_net_total',
                "placeholder" => 'eee::order.placeholder.company_split_net_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'net_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.net_total',
                "placeholder" => 'eee::order.placeholder.net_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'discount_total' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.discount_total',
                "placeholder" => 'eee::order.placeholder.discount_total',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'coupon_discount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.coupon_discount',
                "placeholder" => 'eee::order.placeholder.coupon_discount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'credit_balance_discount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.credit_balance_discount',
                "placeholder" => 'eee::order.placeholder.credit_balance_discount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.amount',
                "placeholder" => 'eee::order.placeholder.amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'tax_percentage' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.tax_percentage',
                "placeholder" => 'eee::order.placeholder.tax_percentage',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'taxable_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.taxable_amount',
                "placeholder" => 'eee::order.placeholder.taxable_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_tax_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.supplier_tax_amount',
                "placeholder" => 'eee::order.placeholder.supplier_tax_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'b2buy_tax_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.b2buy_tax_amount',
                "placeholder" => 'eee::order.placeholder.b2buy_tax_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'b2buy_margin_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.b2buy_margin_amount',
                "placeholder" => 'eee::order.placeholder.b2buy_margin_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'admin_fee' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.admin_fee',
                "placeholder" => 'eee::order.placeholder.admin_fee',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'margin_label' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.margin_label',
                "placeholder" => 'eee::order.placeholder.margin_label',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'commision_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.commision_amount',
                "placeholder" => 'eee::order.placeholder.commision_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'paid_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.paid_amount',
                "placeholder" => 'eee::order.placeholder.paid_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'refund_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.refund_amount',
                "placeholder" => 'eee::order.placeholder.refund_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'refund_total_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.refund_total_amount',
                "placeholder" => 'eee::order.placeholder.refund_total_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'refund_tax_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.refund_tax_amount',
                "placeholder" => 'eee::order.placeholder.refund_tax_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_refund_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_refund_amount',
                "placeholder" => 'eee::order.placeholder.client_refund_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_refund_tax_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_refund_tax_amount',
                "placeholder" => 'eee::order.placeholder.client_refund_tax_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_refund_total_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.client_refund_total_amount',
                "placeholder" => 'eee::order.placeholder.client_refund_total_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_refund_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_refund_amount',
                "placeholder" => 'eee::order.placeholder.company_refund_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_refund_tax_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_refund_tax_amount',
                "placeholder" => 'eee::order.placeholder.company_refund_tax_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_refund_total_amount' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'eee::order.label.company_refund_total_amount',
                "placeholder" => 'eee::order.placeholder.company_refund_total_amount',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_payment_mode' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.company_payment_mode',
                "placeholder" => 'eee::order.placeholder.company_payment_mode',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_payment_mode' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.client_payment_mode',
                "placeholder" => 'eee::order.placeholder.client_payment_mode',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'b2b_managed_payment' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.b2b_managed_payment',
                "placeholder" => 'eee::order.placeholder.b2b_managed_payment',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'is_payment_term' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.is_payment_term',
                "placeholder" => 'eee::order.placeholder.is_payment_term',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_rule_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.payment_rule_type',
                "placeholder" => 'eee::order.placeholder.payment_rule_type',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'refund_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.refund_type',
                "placeholder" => 'eee::order.placeholder.refund_type',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_refund_status' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.client_refund_status',
                "placeholder" => 'eee::order.placeholder.client_refund_status',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_refund_status' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.company_refund_status',
                "placeholder" => 'eee::order.placeholder.company_refund_status',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'company_payment_status' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.company_payment_status',
                "placeholder" => 'eee::order.placeholder.company_payment_status',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_payment_status' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.client_payment_status',
                "placeholder" => 'eee::order.placeholder.client_payment_status',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'withdrawal_status' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.withdrawal_status',
                "placeholder" => 'eee::order.placeholder.withdrawal_status',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_docs' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.payment_docs',
                "placeholder" => 'eee::order.placeholder.payment_docs',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_docs_client' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.payment_docs_client',
                "placeholder" => 'eee::order.placeholder.payment_docs_client',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'refund_docs' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.refund_docs',
                "placeholder" => 'eee::order.placeholder.refund_docs',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_reference_number' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.payment_reference_number',
                "placeholder" => 'eee::order.placeholder.payment_reference_number',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_reference_number_client' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.payment_reference_number_client',
                "placeholder" => 'eee::order.placeholder.payment_reference_number_client',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'refund_reference_number' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.refund_reference_number',
                "placeholder" => 'eee::order.placeholder.refund_reference_number',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_status_log' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.payment_status_log',
                "placeholder" => 'eee::order.placeholder.payment_status_log',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'order_status_log' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.order_status_log',
                "placeholder" => 'eee::order.placeholder.order_status_log',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'approval_status' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.approval_status',
                "placeholder" => 'eee::order.placeholder.approval_status',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'approval_log' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.approval_log',
                "placeholder" => 'eee::order.placeholder.approval_log',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'order_update_log' => [
                "element" => 'html_editor',
                "type" => 'html_editor',
                "label" => 'eee::order.label.order_update_log',
                "placeholder" => 'eee::order.placeholder.order_update_log',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "12",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'review_state' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.review_state',
                "placeholder" => 'eee::order.placeholder.review_state',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'payment_error' => [
                "element" => 'html_editor',
                "type" => 'html_editor',
                "label" => 'eee::order.label.payment_error',
                "placeholder" => 'eee::order.placeholder.payment_error',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "12",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'withdrawal_error' => [
                "element" => 'html_editor',
                "type" => 'html_editor',
                "label" => 'eee::order.label.withdrawal_error',
                "placeholder" => 'eee::order.placeholder.withdrawal_error',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "12",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'webhook_states' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.webhook_states',
                "placeholder" => 'eee::order.placeholder.webhook_states',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_track_code' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.delivery_track_code',
                "placeholder" => 'eee::order.placeholder.delivery_track_code',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_track_link' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.delivery_track_link',
                "placeholder" => 'eee::order.placeholder.delivery_track_link',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_description' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.delivery_description',
                "placeholder" => 'eee::order.placeholder.delivery_description',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_instructions' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.delivery_instructions',
                "placeholder" => 'eee::order.placeholder.delivery_instructions',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'cancel_note' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.cancel_note',
                "placeholder" => 'eee::order.placeholder.cancel_note',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'cancelled_user' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.cancelled_user',
                "placeholder" => 'eee::order.placeholder.cancelled_user',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'settle_date' => [
                "element" => 'date_time_picker',
                "type" => 'date_time_picker',
                "label" => 'eee::order.label.settle_date',
                "placeholder" => 'eee::order.placeholder.settle_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'due_date' => [
                "element" => 'date_time_picker',
                "type" => 'date_time_picker',
                "label" => 'eee::order.label.due_date',
                "placeholder" => 'eee::order.placeholder.due_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'confirmed_date' => [
                "element" => 'date_time_picker',
                "type" => 'date_time_picker',
                "label" => 'eee::order.label.confirmed_date',
                "placeholder" => 'eee::order.placeholder.confirmed_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_type' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.delivery_type',
                "placeholder" => 'eee::order.placeholder.delivery_type',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'cost_center_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.cost_center_id',
                "placeholder" => 'eee::order.placeholder.cost_center_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'department_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.department_id',
                "placeholder" => 'eee::order.placeholder.department_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'manager_role' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.manager_role',
                "placeholder" => 'eee::order.placeholder.manager_role',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'loading_dock' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.loading_dock',
                "placeholder" => 'eee::order.placeholder.loading_dock',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'forklift' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.forklift',
                "placeholder" => 'eee::order.placeholder.forklift',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'intercom_num' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.intercom_num',
                "placeholder" => 'eee::order.placeholder.intercom_num',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'contact_info' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.contact_info',
                "placeholder" => 'eee::order.placeholder.contact_info',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_used' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.delivery_used',
                "placeholder" => 'eee::order.placeholder.delivery_used',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_window_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.delivery_window_id',
                "placeholder" => 'eee::order.placeholder.delivery_window_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivery_window_date' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'eee::order.label.delivery_window_date',
                "placeholder" => 'eee::order.placeholder.delivery_window_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'click_collect_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.click_collect_id',
                "placeholder" => 'eee::order.placeholder.click_collect_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'time_slot' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.time_slot',
                "placeholder" => 'eee::order.placeholder.time_slot',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'alternative_address_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::order.label.alternative_address_id',
                "placeholder" => 'eee::order.placeholder.alternative_address_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'order_note' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.order_note',
                "placeholder" => 'eee::order.placeholder.order_note',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'order_method' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'eee::order.label.order_method',
                "placeholder" => 'eee::order.placeholder.order_method',
                "rules" => '',
                "options" => function(){
                    return [];
                },
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'appointment_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::order.label.appointment_id',
                "placeholder" => 'eee::order.placeholder.appointment_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'eee/order/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'eee/order/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'eee/order',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'eee/order',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'eee/order',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'eee/order',
                'method' => 'DELETE',
            ],
        ],
        'order' => [
            'created_at' => 'eee::order.label.created_at',
            'name' => 'eee::order.label.name',
            'status' => 'eee::order.label.status',
        ],
        'groups' => [
            'main' => 'eee::order.groups.main',
            'details' => 'eee::order.groups.details',
            'images' => 'eee::order.groups.images',
            'settings' => 'eee::order.groups.settings',
        ],
        'controller' => [
            'provider' => 'Order',
            'package' => 'Eee',
            'module' => 'Order',
        ],
    ];
