<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderProductRelationsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: order_product_relations
         */
        Schema::create('order_product_relations', function ($table) {
            $table->increments('id');
            $table->integer('company_id')->nullable();
            $table->integer('seller_company_id')->nullable();
            $table->integer('order_id')->nullable();
            $table->integer('product_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('allocate_id')->nullable();
            $table->integer('po_line_number')->nullable();
            $table->integer('seller_id')->nullable();
            $table->integer('quantity')->nullable();
            $table->decimal('cost_price', 8,2)->nullable();
            $table->decimal('total_cost_price', 8,2)->nullable();
            $table->decimal('unit_price', 8,2)->nullable();
            $table->decimal('total_price', 8,2)->nullable();
            $table->integer('reduced_quantity')->nullable();
            $table->integer('quantity_dropped')->nullable();
            $table->integer('quantity_updated')->nullable();
            $table->decimal('price_dropped', 8,2)->nullable();
            $table->decimal('cost_price_dropped', 8,2)->nullable();
            $table->decimal('company_price_dropped', 8,2)->nullable();
            $table->decimal('client_price_dropped', 8,2)->nullable();
            $table->decimal('company_split_amount', 8,2)->nullable();
            $table->decimal('client_split_amount', 8,2)->nullable();
            $table->decimal('company_split_total_amount', 8,2)->nullable();
            $table->decimal('client_split_total_amount', 8,2)->nullable();
            $table->text('product_name')->nullable();
            $table->text('product_images')->nullable();
            $table->string('product_category', 100)->nullable();
            $table->string('product_unspsc', 255)->nullable();
            $table->enum('product_status', [])->nullable();
            $table->integer('replaced_status')->nullable();
            $table->integer('replaced_item')->nullable();
            $table->string('received', 20)->nullable();
            $table->string('pending', 20)->nullable();
            $table->text('notes')->nullable();
            $table->decimal('tax_amount', 8,2)->nullable();
            $table->decimal('client_tax_amount', 8,2)->nullable();
            $table->decimal('company_tax_amount', 8,2)->nullable();
            $table->decimal('client_tax_dropped', 8,2)->nullable();
            $table->decimal('company_tax_dropped', 8,2)->nullable();
            $table->decimal('tax_dropped', 8,2)->nullable();
            $table->decimal('tax_rate', 8,2)->nullable();
            $table->enum('tax_free', [])->nullable();
            $table->integer('minimum_order_qty')->nullable();
            $table->decimal('margin', 8,2)->nullable();
            $table->decimal('margin_total', 8,2)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('order_product_relations');
    }
}
