<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: orders
         */
        Schema::create('orders', function ($table) {
            $table->increments('id');
            $table->integer('company_id')->nullable();
            $table->integer('seller_company_id')->nullable();
            $table->string('order_code', 255)->nullable();
            $table->integer('seller_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('placed_user_id')->nullable();
            $table->string('coupa_po_number', 150)->nullable();
            $table->string('reference_no', 150)->nullable();
            $table->string('internal_reference', 100)->nullable();
            $table->string('item_charge_id', 255)->nullable();
            $table->string('account_id', 100)->nullable();
            $table->string('admin_account_id', 100)->nullable();
            $table->string('supplier_account_id', 100)->nullable();
            $table->string('batch_trans_id', 150)->nullable();
            $table->string('trans_id', 150)->nullable();
            $table->string('quote_id', 150)->nullable();
            $table->integer('approval_id')->nullable();
            $table->integer('store_id')->nullable();
            $table->integer('split_payment')->nullable();
            $table->enum('user_payment_type', [])->nullable();
            $table->enum('payment_lock', [])->nullable();
            $table->enum('client_edit', [])->nullable();
            $table->enum('substitute_favourite', [])->nullable();
            $table->enum('substitute_coles', [])->nullable();
            $table->integer('stock_notify_qty')->nullable();
            $table->string('buyer_company_name', 255)->nullable();
            $table->string('buyer_company_trading_name', 255)->nullable();
            $table->string('buyer_company_abn', 100)->nullable();
            $table->string('buyer_company_phone', 20)->nullable();
            $table->string('buyer_company_email', 100)->nullable();
            $table->string('supplier_company_name', 255)->nullable();
            $table->string('supplier_company_trading_name', 255)->nullable();
            $table->string('supplier_company_abn', 100)->nullable();
            $table->string('supplier_company_phone', 20)->nullable();
            $table->string('supplier_company_email', 100)->nullable();
            $table->enum('shipping_type', [])->nullable();
            $table->string('f_name', 255)->nullable();
            $table->string('l_name', 255)->nullable();
            $table->string('company_name', 255)->nullable();
            $table->string('deliver_to', 255)->nullable();
            $table->string('state', 60)->nullable();
            $table->string('country', 60)->nullable();
            $table->text('sreet_address')->nullable();
            $table->string('suburb', 100)->nullable();
            $table->string('zip_code', 255)->nullable();
            $table->string('bill_address_to', 120)->nullable();
            $table->text('bill_sreet_address')->nullable();
            $table->string('bill_suburb', 255)->nullable();
            $table->string('bill_state', 60)->nullable();
            $table->string('bill_country', 60)->nullable();
            $table->string('bill_zip_code', 255)->nullable();
            $table->decimal('cost_total', 8,2)->nullable();
            $table->decimal('cart_total', 8,2)->nullable();
            $table->decimal('margin_total', 8,2)->nullable();
            $table->decimal('shipping_charge', 8,2)->nullable();
            $table->decimal('shipping_tax_amount', 8,2)->nullable();
            $table->decimal('subtotal', 8,2)->nullable();
            $table->decimal('total', 8,2)->nullable();
            $table->decimal('transaction_charge', 8,2)->nullable();
            $table->decimal('admin_transaction_charge', 8,2)->nullable();
            $table->decimal('client_transaction_charge', 8,2)->nullable();
            $table->decimal('company_split_amount', 8,2)->nullable();
            $table->decimal('client_split_amount', 8,2)->nullable();
            $table->decimal('client_split_sub_total', 8,2)->nullable();
            $table->decimal('company_split_sub_total', 8,2)->nullable();
            $table->decimal('client_split_tax', 8,2)->nullable();
            $table->decimal('company_split_tax', 8,2)->nullable();
            $table->decimal('client_split_total', 8,2)->nullable();
            $table->decimal('company_split_total', 8,2)->nullable();
            $table->decimal('client_split_net_total', 8,2)->nullable();
            $table->decimal('client_discount', 8,2)->nullable();
            $table->decimal('company_discount', 8,2)->nullable();
            $table->decimal('company_split_net_total', 8,2)->nullable();
            $table->decimal('net_total', 8,2)->nullable();
            $table->double('discount_total', 8,2)->nullable();
            $table->decimal('coupon_discount', 8,2)->nullable();
            $table->decimal('credit_balance_discount', 8,2)->nullable();
            $table->double('amount', 8,2)->nullable();
            $table->decimal('tax_percentage', 8,2)->nullable();
            $table->decimal('taxable_amount', 8,2)->nullable();
            $table->decimal('supplier_tax_amount', 8,2)->nullable();
            $table->decimal('b2buy_tax_amount', 8,2)->nullable();
            $table->decimal('b2buy_margin_amount', 8,2)->nullable();
            $table->decimal('admin_fee', 8,2)->nullable();
            $table->enum('margin_label', [])->nullable();
            $table->decimal('commision_amount', 8,2)->nullable();
            $table->double('paid_amount', 8,2)->nullable();
            $table->decimal('refund_amount', 8,2)->nullable();
            $table->decimal('refund_total_amount', 8,2)->nullable();
            $table->decimal('refund_tax_amount', 8,2)->nullable();
            $table->decimal('client_refund_amount', 8,2)->nullable();
            $table->decimal('client_refund_tax_amount', 8,2)->nullable();
            $table->decimal('client_refund_total_amount', 8,2)->nullable();
            $table->decimal('company_refund_amount', 8,2)->nullable();
            $table->decimal('company_refund_tax_amount', 8,2)->nullable();
            $table->decimal('company_refund_total_amount', 8,2)->nullable();
            $table->enum('company_payment_mode', [])->nullable();
            $table->enum('client_payment_mode', [])->nullable();
            $table->enum('b2b_managed_payment', [])->nullable();
            $table->integer('is_payment_term')->nullable();
            $table->enum('payment_rule_type', [])->nullable();
            $table->enum('refund_type', [])->nullable();
            $table->enum('client_refund_status', [])->nullable();
            $table->enum('company_refund_status', [])->nullable();
            $table->enum('company_payment_status', [])->nullable();
            $table->enum('client_payment_status', [])->nullable();
            $table->enum('withdrawal_status', [])->nullable();
            $table->text('payment_docs')->nullable();
            $table->text('payment_docs_client')->nullable();
            $table->text('refund_docs')->nullable();
            $table->string('payment_reference_number', 255)->nullable();
            $table->string('payment_reference_number_client', 255)->nullable();
            $table->string('refund_reference_number', 255)->nullable();
            $table->text('payment_status_log')->nullable();
            $table->enum('status', [])->nullable();
            $table->text('order_status_log')->nullable();
            $table->enum('approval_status', [])->nullable();
            $table->text('approval_log')->nullable();
            $table->longText('order_update_log')->nullable();
            $table->integer('review_state')->nullable();
            $table->longText('payment_error')->nullable();
            $table->longText('withdrawal_error')->nullable();
            $table->enum('webhook_states', [])->nullable();
            $table->string('delivery_track_code', 100)->nullable();
            $table->text('delivery_track_link')->nullable();
            $table->text('delivery_description')->nullable();
            $table->text('delivery_instructions')->nullable();
            $table->text('cancel_note')->nullable();
            $table->integer('cancelled_user')->nullable();
            $table->string('user_type', 100)->nullable();
            $table->timestamp('settle_date')->nullable();
            $table->timestamp('due_date')->nullable();
            $table->timestamp('confirmed_date')->nullable();
            $table->integer('delivery_type')->nullable();
            $table->integer('cost_center_id')->nullable();
            $table->integer('department_id')->nullable();
            $table->integer('manager_role')->nullable();
            $table->string('loading_dock', 255)->nullable();
            $table->string('forklift', 255)->nullable();
            $table->string('intercom_num', 255)->nullable();
            $table->string('contact_info', 255)->nullable();
            $table->string('delivery_used', 255)->nullable();
            $table->integer('delivery_window_id')->nullable();
            $table->date('delivery_window_date')->nullable();
            $table->integer('click_collect_id')->nullable();
            $table->text('time_slot')->nullable();
            $table->integer('alternative_address_id')->nullable();
            $table->text('order_note')->nullable();
            $table->enum('order_method', [])->nullable();
            $table->string('appointment_id', 150)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('orders');
    }
}
