<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: products
         */
        Schema::create('products', function ($table) {
            $table->increments('id');
            $table->integer('company_id')->nullable();
            $table->integer('seller_company_id')->nullable();
            $table->integer('product_id')->nullable();
            $table->integer('subscription_id')->nullable();
            $table->integer('quantity')->nullable();
            $table->string('repeat_interval', 255)->nullable();
            $table->integer('scheduler_id')->nullable();
            $table->integer('notification_schedule_id')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->date('delivey_date')->nullable();
            $table->date('skiped_date')->nullable();
            $table->date('notification_date')->nullable();
            $table->enum('status', [])->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('products');
    }
}
