<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: subscriptions
         */
        Schema::create('subscriptions', function ($table) {
            $table->increments('id');
            $table->integer('company_id')->nullable();
            $table->integer('seller_company_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('seller_id')->nullable();
            $table->integer('order_id')->nullable();
            $table->integer('cart_id')->nullable();
            $table->integer('address_id')->nullable();
            $table->enum('status', [])->nullable();
            $table->integer('delivery_type')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('subscriptions');
    }
}
