<?php

namespace Order\Eee\Seeders;

use DB;
use Illuminate\Database\Seeder;

class OrderProductRelationTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('order_product_relations')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'eee.order_product_relation.view',
                'name'      => 'View OrderProductRelation',
            ],
            [
                'slug'      => 'eee.order_product_relation.create',
                'name'      => 'Create OrderProductRelation',
            ],
            [
                'slug'      => 'eee.order_product_relation.edit',
                'name'      => 'Update OrderProductRelation',
            ],
            [
                'slug'      => 'eee.order_product_relation.delete',
                'name'      => 'Delete OrderProductRelation',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/eee/order_product_relation',
                'name'        => 'OrderProductRelation',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/eee/order_product_relation',
                'name'        => 'OrderProductRelation',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'order_product_relation',
                'name'        => 'OrderProductRelation',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Eee',
                'module'    => 'OrderProductRelation',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'eee.order_product_relation.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
