# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/order/eee/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Order\\Eee\\": "packages/order/eee/src",
            "Order\\Eee\\Seeders\\": "packages/order/eee/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Order\Eee\Providers\EeeServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Eee'  => Order\Eee\Facades\Eee::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Order\\Eee\\Seeders\\EeeTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Order\Eee\Providers\EeeServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Order\Eee\Providers\EeeServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Order\Eee\Providers\EeeServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/eee/{modulename}

**User**

    http://path-to-route-folder/user/eee/{modulename}

**Public**

    http://path-to-route-folder/eees


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/eee/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/eee/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/eee/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/eee/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/eee/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/eee/{modulename}/{slug}
    METHOD: GET