<?php

namespace Order\Eee\Http\Controllers;

use Exception;
use Litepie\Http\Controllers\ResourceController as BaseController;
use Litepie\Database\RequestScope;
use Order\Eee\Forms\OrderProductRelation as OrderProductRelationForm;
use Order\Eee\Http\Requests\OrderProductRelationRequest;
use Order\Eee\Http\Resources\OrderProductRelationResource;
use Order\Eee\Http\Resources\OrderProductRelationsCollection;
use Order\Eee\Models\OrderProductRelation;
use Order\Eee\Scopes\OrderProductRelationResourceScope;


/**
 * Resource controller class for order_product_relation.
 */
class OrderProductRelationResourceController extends BaseController
{

    /**
     * Initialize order_product_relation resource controller.
     *
     *
     * @return null
     */
    public function __construct()
    {
        parent::__construct();
        $this->form = OrderProductRelationForm::grouped(false)
                        ->setAttributes()
                        ->toArray();
        $this->modules = $this->modules(config('order.eee.modules'), 'eee', guard_url('eee'));
    }

    /**
     * Display a list of order_product_relation.
     *
     * @return Response
     */
    public function index(OrderProductRelationRequest $request)
    {

        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $page = OrderProductRelation::pushScope(new RequestScope())
            ->pushScope(new OrderProductRelationResourceScope())
            ->simplePaginate($pageLimit);

        $data = new OrderProductRelationsCollection($page);

        $form = $this->form;
        $modules = $this->modules;

        return $this->response->setMetaTitle(trans('eee::order_product_relation.names'))
            ->view('eee::order_product_relation.index')
            ->data(compact('data', 'modules', 'form'))
            ->output();

    }

    /**
     * Display order_product_relation.
     *
     * @param Request $request
     * @param Model   $order_product_relation
     *
     * @return Response
     */
    public function show(OrderProductRelationRequest $request, OrderProductRelation $model)
    {
        $form = $this->form;
        $modules = $this->modules;
        $data = new OrderProductRelationResource($model);

        return $this->response
            ->setMetaTitle(trans('app.view') . ' ' . trans('eee::order_product_relation.name'))
            ->data(compact('data', 'form', 'modules'))
            ->view('eee::order_product_relation.show')
            ->output();

    }

    /**
     * Show the form for creating a new order_product_relation.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(OrderProductRelationRequest $request, OrderProductRelation $model)
    {
        $form = $this->form;
        $modules = $this->modules;
        $data = new OrderProductRelationResource($model);
        return $this->response->setMetaTitle(trans('app.new') . ' ' . trans('eee::order_product_relation.name'))
            ->view('eee::order_product_relation.create')
            ->data(compact('data', 'form', 'modules'))
            ->output();

    }

    /**
     * Create new order_product_relation.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(OrderProductRelationRequest $request, OrderProductRelation $model)
    {
        try {
            $attributes = $request->all();
            $attributes['user_id'] = user_id();
            $attributes['user_type'] = user_type();
            $model = $model->create($attributes);
            $data = new OrderProductRelationResource($model);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('eee::order_product_relation.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('eee/order_product_relation/' . $model->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/eee/order_product_relation'))
                ->redirect();
        }

    }

    /**
     * Show order_product_relation for editing.
     *
     * @param Request $request
     * @param Model   $order_product_relation
     *
     * @return Response
     */
    public function edit(OrderProductRelationRequest $request, OrderProductRelation $model)
    {
        $form = $this->form;
        $modules = $this->modules;
        $data = new OrderProductRelationResource($model);

        return $this->response->setMetaTitle(trans('app.edit') . ' ' . trans('eee::order_product_relation.name'))
            ->view('eee::order_product_relation.edit')
            ->data(compact('data', 'form', 'modules'))
            ->output();

    }

    /**
     * Update the order_product_relation.
     *
     * @param Request $request
     * @param Model   $order_product_relation
     *
     * @return Response
     */
    public function update(OrderProductRelationRequest $request, OrderProductRelation $model)
    {
        try {
            $attributes = $request->all();
            $model = $model->update($attributes);
            $data = new OrderProductRelationResource($model);

            return $this->response->message(trans('messages.success.updated', ['Module' => trans('eee::order_product_relation.name')]))
                ->code(204)
                ->status('success')
                ->data(compact('data'))
                ->url(guard_url('eee/order_product_relation/' . $model->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('eee/order_product_relation/' .  $model->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the order_product_relation.
     *
     * @param Model   $order_product_relation
     *
     * @return Response
     */
    public function destroy(OrderProductRelationRequest $request, OrderProductRelation $model)
    {
        try {
            $model->delete();
            $data = new OrderProductRelationResource($model);

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('eee::order_product_relation.name')]))
                ->code(202)
                ->status('success')
                ->data(compact('data'))
                ->url(guard_url('eee/order_product_relation/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('eee/order_product_relation/' .  $model->getRouteKey()))
                ->redirect();
        }

    }
}
