<?php

namespace Order\Eee\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderProductRelationResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('eee/order_product_relation') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'company_id' => $this->company_id,
            'seller_company_id' => $this->seller_company_id,
            'order_id' => $this->order_id,
            'product_id' => $this->product_id,
            'user_id' => $this->user_id,
            'allocate_id' => $this->allocate_id,
            'po_line_number' => $this->po_line_number,
            'seller_id' => $this->seller_id,
            'quantity' => $this->quantity,
            'cost_price' => $this->cost_price,
            'total_cost_price' => $this->total_cost_price,
            'unit_price' => $this->unit_price,
            'total_price' => $this->total_price,
            'reduced_quantity' => $this->reduced_quantity,
            'quantity_dropped' => $this->quantity_dropped,
            'quantity_updated' => $this->quantity_updated,
            'price_dropped' => $this->price_dropped,
            'cost_price_dropped' => $this->cost_price_dropped,
            'company_price_dropped' => $this->company_price_dropped,
            'client_price_dropped' => $this->client_price_dropped,
            'company_split_amount' => $this->company_split_amount,
            'client_split_amount' => $this->client_split_amount,
            'company_split_total_amount' => $this->company_split_total_amount,
            'client_split_total_amount' => $this->client_split_total_amount,
            'product_name' => $this->product_name,
            'product_images' => $this->product_images,
            'product_category' => $this->product_category,
            'product_unspsc' => $this->product_unspsc,
            'product_status' => $this->product_status,
            'replaced_status' => $this->replaced_status,
            'replaced_item' => $this->replaced_item,
            'received' => $this->received,
            'pending' => $this->pending,
            'notes' => $this->notes,
            'tax_amount' => $this->tax_amount,
            'client_tax_amount' => $this->client_tax_amount,
            'company_tax_amount' => $this->company_tax_amount,
            'client_tax_dropped' => $this->client_tax_dropped,
            'company_tax_dropped' => $this->company_tax_dropped,
            'tax_dropped' => $this->tax_dropped,
            'tax_rate' => $this->tax_rate,
            'tax_free' => $this->tax_free,
            'minimum_order_qty' => $this->minimum_order_qty,
            'margin' => $this->margin,
            'margin_total' => $this->margin_total,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
