<?php

namespace Order\Eee\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('eee/order') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'company_id' => $this->company_id,
            'seller_company_id' => $this->seller_company_id,
            'order_code' => $this->order_code,
            'seller_id' => $this->seller_id,
            'user_id' => $this->user_id,
            'placed_user_id' => $this->placed_user_id,
            'coupa_po_number' => $this->coupa_po_number,
            'reference_no' => $this->reference_no,
            'internal_reference' => $this->internal_reference,
            'item_charge_id' => $this->item_charge_id,
            'account_id' => $this->account_id,
            'admin_account_id' => $this->admin_account_id,
            'supplier_account_id' => $this->supplier_account_id,
            'batch_trans_id' => $this->batch_trans_id,
            'trans_id' => $this->trans_id,
            'quote_id' => $this->quote_id,
            'approval_id' => $this->approval_id,
            'store_id' => $this->store_id,
            'split_payment' => $this->split_payment,
            'user_payment_type' => $this->user_payment_type,
            'payment_lock' => $this->payment_lock,
            'client_edit' => $this->client_edit,
            'substitute_favourite' => $this->substitute_favourite,
            'substitute_coles' => $this->substitute_coles,
            'stock_notify_qty' => $this->stock_notify_qty,
            'buyer_company_name' => $this->buyer_company_name,
            'buyer_company_trading_name' => $this->buyer_company_trading_name,
            'buyer_company_abn' => $this->buyer_company_abn,
            'buyer_company_phone' => $this->buyer_company_phone,
            'buyer_company_email' => $this->buyer_company_email,
            'supplier_company_name' => $this->supplier_company_name,
            'supplier_company_trading_name' => $this->supplier_company_trading_name,
            'supplier_company_abn' => $this->supplier_company_abn,
            'supplier_company_phone' => $this->supplier_company_phone,
            'supplier_company_email' => $this->supplier_company_email,
            'shipping_type' => $this->shipping_type,
            'f_name' => $this->f_name,
            'l_name' => $this->l_name,
            'company_name' => $this->company_name,
            'deliver_to' => $this->deliver_to,
            'state' => $this->state,
            'country' => $this->country,
            'sreet_address' => $this->sreet_address,
            'suburb' => $this->suburb,
            'zip_code' => $this->zip_code,
            'bill_address_to' => $this->bill_address_to,
            'bill_sreet_address' => $this->bill_sreet_address,
            'bill_suburb' => $this->bill_suburb,
            'bill_state' => $this->bill_state,
            'bill_country' => $this->bill_country,
            'bill_zip_code' => $this->bill_zip_code,
            'cost_total' => $this->cost_total,
            'cart_total' => $this->cart_total,
            'margin_total' => $this->margin_total,
            'shipping_charge' => $this->shipping_charge,
            'shipping_tax_amount' => $this->shipping_tax_amount,
            'subtotal' => $this->subtotal,
            'total' => $this->total,
            'transaction_charge' => $this->transaction_charge,
            'admin_transaction_charge' => $this->admin_transaction_charge,
            'client_transaction_charge' => $this->client_transaction_charge,
            'company_split_amount' => $this->company_split_amount,
            'client_split_amount' => $this->client_split_amount,
            'client_split_sub_total' => $this->client_split_sub_total,
            'company_split_sub_total' => $this->company_split_sub_total,
            'client_split_tax' => $this->client_split_tax,
            'company_split_tax' => $this->company_split_tax,
            'client_split_total' => $this->client_split_total,
            'company_split_total' => $this->company_split_total,
            'client_split_net_total' => $this->client_split_net_total,
            'client_discount' => $this->client_discount,
            'company_discount' => $this->company_discount,
            'company_split_net_total' => $this->company_split_net_total,
            'net_total' => $this->net_total,
            'discount_total' => $this->discount_total,
            'coupon_discount' => $this->coupon_discount,
            'credit_balance_discount' => $this->credit_balance_discount,
            'amount' => $this->amount,
            'tax_percentage' => $this->tax_percentage,
            'taxable_amount' => $this->taxable_amount,
            'supplier_tax_amount' => $this->supplier_tax_amount,
            'b2buy_tax_amount' => $this->b2buy_tax_amount,
            'b2buy_margin_amount' => $this->b2buy_margin_amount,
            'admin_fee' => $this->admin_fee,
            'margin_label' => $this->margin_label,
            'commision_amount' => $this->commision_amount,
            'paid_amount' => $this->paid_amount,
            'refund_amount' => $this->refund_amount,
            'refund_total_amount' => $this->refund_total_amount,
            'refund_tax_amount' => $this->refund_tax_amount,
            'client_refund_amount' => $this->client_refund_amount,
            'client_refund_tax_amount' => $this->client_refund_tax_amount,
            'client_refund_total_amount' => $this->client_refund_total_amount,
            'company_refund_amount' => $this->company_refund_amount,
            'company_refund_tax_amount' => $this->company_refund_tax_amount,
            'company_refund_total_amount' => $this->company_refund_total_amount,
            'company_payment_mode' => $this->company_payment_mode,
            'client_payment_mode' => $this->client_payment_mode,
            'b2b_managed_payment' => $this->b2b_managed_payment,
            'is_payment_term' => $this->is_payment_term,
            'payment_rule_type' => $this->payment_rule_type,
            'refund_type' => $this->refund_type,
            'client_refund_status' => $this->client_refund_status,
            'company_refund_status' => $this->company_refund_status,
            'company_payment_status' => $this->company_payment_status,
            'client_payment_status' => $this->client_payment_status,
            'withdrawal_status' => $this->withdrawal_status,
            'payment_docs' => $this->payment_docs,
            'payment_docs_client' => $this->payment_docs_client,
            'refund_docs' => $this->refund_docs,
            'payment_reference_number' => $this->payment_reference_number,
            'payment_reference_number_client' => $this->payment_reference_number_client,
            'refund_reference_number' => $this->refund_reference_number,
            'payment_status_log' => $this->payment_status_log,
            'status' => $this->status,
            'order_status_log' => $this->order_status_log,
            'approval_status' => $this->approval_status,
            'approval_log' => $this->approval_log,
            'order_update_log' => $this->order_update_log,
            'review_state' => $this->review_state,
            'payment_error' => $this->payment_error,
            'withdrawal_error' => $this->withdrawal_error,
            'webhook_states' => $this->webhook_states,
            'delivery_track_code' => $this->delivery_track_code,
            'delivery_track_link' => $this->delivery_track_link,
            'delivery_description' => $this->delivery_description,
            'delivery_instructions' => $this->delivery_instructions,
            'cancel_note' => $this->cancel_note,
            'cancelled_user' => $this->cancelled_user,
            'user_type' => $this->user_type,
            'settle_date' => $this->settle_date,
            'due_date' => $this->due_date,
            'confirmed_date' => $this->confirmed_date,
            'delivery_type' => $this->delivery_type,
            'cost_center_id' => $this->cost_center_id,
            'department_id' => $this->department_id,
            'manager_role' => $this->manager_role,
            'loading_dock' => $this->loading_dock,
            'forklift' => $this->forklift,
            'intercom_num' => $this->intercom_num,
            'contact_info' => $this->contact_info,
            'delivery_used' => $this->delivery_used,
            'delivery_window_id' => $this->delivery_window_id,
            'delivery_window_date' => $this->delivery_window_date,
            'click_collect_id' => $this->click_collect_id,
            'time_slot' => $this->time_slot,
            'alternative_address_id' => $this->alternative_address_id,
            'order_note' => $this->order_note,
            'order_method' => $this->order_method,
            'appointment_id' => $this->appointment_id,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
