<?php

namespace Order\Eee\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Order\Eee\Models\Order;

class OrderPolicy
{

    /**
     * Determine if the given user can view the order.
     *
     * @param UserPolicyInterface $authUser
     * @param Order $order
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Order $order)
    {
        if ($authUser->canDo('eee.order.view') && $authUser->isAdmin()) {
            return true;
        }

        return $order->user_id == user_id() && $order->user_type == user_type();
    }

    /**
     * Determine if the given user can create a order.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('eee.order.create');
    }

    /**
     * Determine if the given user can update the given order.
     *
     * @param UserPolicyInterface $authUser
     * @param Order $order
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Order $order)
    {
        if ($authUser->canDo('eee.order.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $order->user_id == user_id() && $order->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given order.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Order $order)
    {
        return $order->user_id == user_id() && $order->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given order.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Order $order)
    {
        if ($authUser->canDo('eee.order.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given order.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Order $order)
    {
        if ($authUser->canDo('eee.order.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
