<?php

namespace Order\Eee\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Order\Eee\Models\Subscription;

class SubscriptionPolicy
{

    /**
     * Determine if the given user can view the subscription.
     *
     * @param UserPolicyInterface $authUser
     * @param Subscription $subscription
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Subscription $subscription)
    {
        if ($authUser->canDo('eee.subscription.view') && $authUser->isAdmin()) {
            return true;
        }

        return $subscription->user_id == user_id() && $subscription->user_type == user_type();
    }

    /**
     * Determine if the given user can create a subscription.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('eee.subscription.create');
    }

    /**
     * Determine if the given user can update the given subscription.
     *
     * @param UserPolicyInterface $authUser
     * @param Subscription $subscription
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Subscription $subscription)
    {
        if ($authUser->canDo('eee.subscription.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $subscription->user_id == user_id() && $subscription->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given subscription.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Subscription $subscription)
    {
        return $subscription->user_id == user_id() && $subscription->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given subscription.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Subscription $subscription)
    {
        if ($authUser->canDo('eee.subscription.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given subscription.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Subscription $subscription)
    {
        if ($authUser->canDo('eee.subscription.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
