<?php

namespace Order\Eee\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the package.
     *
     * @var array
     */
    protected $policies = [
        // Bind Order policy
        \Order\Eee\Repositories\Eloquent\OrderRepository::class 
        => \Order\Eee\Policies\OrderPolicy::class,// Bind OrderProductRelation policy
        \Order\Eee\Repositories\Eloquent\OrderProductRelationRepository::class 
        => \Order\Eee\Policies\OrderProductRelationPolicy::class,// Bind Subscription policy
        \Order\Eee\Repositories\Eloquent\SubscriptionRepository::class 
        => \Order\Eee\Policies\SubscriptionPolicy::class,// Bind Product policy
        \Order\Eee\Repositories\Eloquent\ProductRepository::class 
        => \Order\Eee\Policies\ProductPolicy::class,
    ];

    /**
     * Register any package authentication / authorization services.
     *
     * @param \Illuminate\Contracts\Auth\Access\Gate $gate
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        parent::registerPolicies($gate);
    }
}
