<?php

namespace Order\Eee\Providers;

use Illuminate\Support\ServiceProvider;
use Order\Eee\Eees;

class EeeServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'eee');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'eee');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        // $this->registerCommands();

        $this->app->register(\Order\Eee\Providers\AuthServiceProvider::class);
        $this->app->register(\Order\Eee\Providers\RouteServiceProvider::class);
        // $this->app->register(\Order\Eee\Providers\EventServiceProvider::class);
        // $this->app->register(\Order\Eee\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('order.eee', function($app)
        {
            return $this->app->make(Eees::class);
        });
    }



    /**
     * Merges user's and eee's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'order.eee'
        );
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/order.php', 'order.eee.order'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/order_product_relation.php', 'order.eee.order_product_relation'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/subscription.php', 'order.eee.subscription'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/product.php', 'order.eee.product'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Order\Eee\Commands\Eee::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['order.eee'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('order/eee')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/eee')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/eee')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
