<?php

namespace Order\Eee\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Order\Eee\Models\Order;
use Order\Eee\Models\OrderProductRelation;
use Order\Eee\Models\Subscription;
use Order\Eee\Models\Product;

use Request;
use Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to the controller routes in your routes file.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'Order\Eee\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @param   \Illuminate\Routing\Router  $router
     * @return void
     */
    public function boot()
    {
        parent::boot();

        if (Request::is('*/eee/order/*')) {
            Route::bind('order', function ($order) {
                return Order::findorNew($order);
            });
        }
        if (Request::is('*/eee/order_product_relation/*')) {
            Route::bind('order_product_relation', function ($order_product_relation) {
                return OrderProductRelation::findorNew($order_product_relation);
            });
        }
        if (Request::is('*/eee/subscription/*')) {
            Route::bind('subscription', function ($subscription) {
                return Subscription::findorNew($subscription);
            });
        }
        if (Request::is('*/eee/product/*')) {
            Route::bind('product', function ($product) {
                return Product::findorNew($product);
            });
        }

    }

    /**
     * Define the routes for the package.
     *
     * @return void
     */
    public function map()
    {
        $this->mapWebRoutes();

        $this->mapApiRoutes();
    }

    /**
     * Define the "web" routes for the package.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {   
        Route::group([
            'middleware' => 'web',
            'namespace'  => $this->namespace,
        ], function ($router) {
            require (__DIR__ . '/../../routes/web.php');
        });
    }

    /**
     * Define the "api" routes for the package.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::group([
            'middleware' => 'api',
            'namespace'  => $this->namespace,
            'prefix'     => 'api',
        ], function ($router) {
            require (__DIR__ . '/../../routes/api.php');
        });
    }

}
