<?php


return  
    [
        'model' => [
            'model' => \Bixo\Payroll\Models\Adjustment::class,
            'table' => 'bixo_payroll_adjustments',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['ref',  'employee_id',  'payroll_id',  'request_id',  'related_id',  'payroll_show',  'payment_date',  'type',  'type_other',  'addition',  'deduction',  'status',  'description',  'notes',  'documents',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'payroll/adjustment',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "ref", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.ref', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "employee_id", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.employee_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payroll_id", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.payroll_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "request_id", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.request_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "related_id", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.related_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payroll_show", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.payroll_show', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payment_date", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.payment_date', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "type", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.type', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "type_other", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.type_other', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "addition", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.addition', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "deduction", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.deduction', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "description", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.description', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "notes", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.notes', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "documents", 
                "type" => "text", 
                "label" => 'payroll::adjustment.label.documents', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'ref',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::adjustment.label.ref',
                "placeholder" => 'payroll::adjustment.placeholder.ref',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'employee_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::adjustment.label.employee_id',
                "placeholder" => 'payroll::adjustment.placeholder.employee_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payroll_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::adjustment.label.payroll_id',
                "placeholder" => 'payroll::adjustment.placeholder.payroll_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'request_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::adjustment.label.request_id',
                "placeholder" => 'payroll::adjustment.placeholder.request_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'related_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::adjustment.label.related_id',
                "placeholder" => 'payroll::adjustment.placeholder.related_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payroll_show',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::adjustment.label.payroll_show',
                "placeholder" => 'payroll::adjustment.placeholder.payroll_show',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payment_date',
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'payroll::adjustment.label.payment_date',
                "placeholder" => 'payroll::adjustment.placeholder.payment_date',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'type',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::adjustment.label.type',
                "placeholder" => 'payroll::adjustment.placeholder.type',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'type_other',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::adjustment.label.type_other',
                "placeholder" => 'payroll::adjustment.placeholder.type_other',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'addition',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::adjustment.label.addition',
                "placeholder" => 'payroll::adjustment.placeholder.addition',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'deduction',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::adjustment.label.deduction',
                "placeholder" => 'payroll::adjustment.placeholder.deduction',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'description',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::adjustment.label.description',
                "placeholder" => 'payroll::adjustment.placeholder.description',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'notes',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::adjustment.label.notes',
                "placeholder" => 'payroll::adjustment.placeholder.notes',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'documents',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::adjustment.label.documents',
                "placeholder" => 'payroll::adjustment.placeholder.documents',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'payroll/adjustment/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'payroll/adjustment/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'payroll/adjustment',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'payroll/adjustment',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'payroll/adjustment',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'payroll/adjustment',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'payroll::adjustment.label.created_at',
            'name' => 'payroll::adjustment.label.name',
            'status' => 'payroll::adjustment.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "payroll::adjustment.groups.main",
                'group' => "main.main",
                'title' => "payroll::adjustment.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "payroll::adjustment.groups.details",
                'group' => "main.details",
                'title' => "payroll::adjustment.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "payroll::adjustment.groups.images",
                'group' => "main.images",
                'title' => "payroll::adjustment.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "payroll::adjustment.groups.settings",
                'group' => "main.settings",
                'title' => "payroll::adjustment.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Bixo',
            'package' => 'Payroll',
            'module' => 'Adjustment',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Bixo\Payroll\Models\Adjustment::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'title' => 'Reject',
                            'button' => [
                                'cancel' > [
                                    'icon' > '',
                                    'varient' > '',
                                    'label' > 'Cancel'
                                ],
                                'submit' > [
                                    'icon' > '',
                                    'varient' > 'primary',
                                    'label' > 'Reject'
                                ]
                            ],
                            'fields' => [
                                'count' => [
                                    "element" => 'select',
                                    "type" => 'select',
                                    "label" => 'advert::advert.label.count',
                                    "placeholder" => 'advert::advert.placeholder.count',
                                    "options" => call_user_func(function () {
                                        return [
                                            1 => ['value' => 1, 'text' => 1],
                                            2 => ['value' => 2, 'text' => 2],
                                            3 => ['value' => 3, 'text' => 3],
                                            4 => ['value' => 4, 'text' => 4],
                                        ];
                                    }),
                                    "col" => "12",
                                ],
                                'comment' => [
                                    "element" => 'textarea',
                                    "type" => 'text',
                                    "required" => 'required',
                                    "label" => 'advert::advert.label.comment',
                                    "placeholder" => 'advert::advert.placeholder.comment',
                                    "col" => "12",
                                ],
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
        
    ];
