<?php


return  
    [
        'model' => [
            'model' => \Bixo\Payroll\Models\Commission::class,
            'table' => 'bixo_payroll_commissions',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['agent_id',  'deal_id',  'payroll_id',  'receipt_id',  'split',  'agent_per',  'agent_com',  'company_com',  'slab_amount',  'additional_per',  'additional_com',  'receipt',  'receipt_type',  'vat',  'type',  'description',  'cutoff_date',  'receipt_date',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'payroll/commission',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "agent_id", 
                "type" => "text", 
                "label" => 'payroll::commission.label.agent_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "deal_id", 
                "type" => "text", 
                "label" => 'payroll::commission.label.deal_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payroll_id", 
                "type" => "text", 
                "label" => 'payroll::commission.label.payroll_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "receipt_id", 
                "type" => "text", 
                "label" => 'payroll::commission.label.receipt_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "split", 
                "type" => "text", 
                "label" => 'payroll::commission.label.split', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "agent_per", 
                "type" => "text", 
                "label" => 'payroll::commission.label.agent_per', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "agent_com", 
                "type" => "text", 
                "label" => 'payroll::commission.label.agent_com', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "company_com", 
                "type" => "text", 
                "label" => 'payroll::commission.label.company_com', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "slab_amount", 
                "type" => "text", 
                "label" => 'payroll::commission.label.slab_amount', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "additional_per", 
                "type" => "text", 
                "label" => 'payroll::commission.label.additional_per', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "additional_com", 
                "type" => "text", 
                "label" => 'payroll::commission.label.additional_com', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "receipt", 
                "type" => "text", 
                "label" => 'payroll::commission.label.receipt', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "receipt_type", 
                "type" => "text", 
                "label" => 'payroll::commission.label.receipt_type', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "vat", 
                "type" => "text", 
                "label" => 'payroll::commission.label.vat', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "type", 
                "type" => "text", 
                "label" => 'payroll::commission.label.type', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "description", 
                "type" => "text", 
                "label" => 'payroll::commission.label.description', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "cutoff_date", 
                "type" => "text", 
                "label" => 'payroll::commission.label.cutoff_date', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "receipt_date", 
                "type" => "text", 
                "label" => 'payroll::commission.label.receipt_date', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'agent_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::commission.label.agent_id',
                "placeholder" => 'payroll::commission.placeholder.agent_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'deal_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::commission.label.deal_id',
                "placeholder" => 'payroll::commission.placeholder.deal_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payroll_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::commission.label.payroll_id',
                "placeholder" => 'payroll::commission.placeholder.payroll_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'receipt_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::commission.label.receipt_id',
                "placeholder" => 'payroll::commission.placeholder.receipt_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'split',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.split',
                "placeholder" => 'payroll::commission.placeholder.split',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'agent_per',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.agent_per',
                "placeholder" => 'payroll::commission.placeholder.agent_per',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'agent_com',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.agent_com',
                "placeholder" => 'payroll::commission.placeholder.agent_com',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'company_com',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.company_com',
                "placeholder" => 'payroll::commission.placeholder.company_com',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'slab_amount',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.slab_amount',
                "placeholder" => 'payroll::commission.placeholder.slab_amount',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'additional_per',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.additional_per',
                "placeholder" => 'payroll::commission.placeholder.additional_per',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'additional_com',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.additional_com',
                "placeholder" => 'payroll::commission.placeholder.additional_com',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'receipt',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.receipt',
                "placeholder" => 'payroll::commission.placeholder.receipt',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'receipt_type',
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'payroll::commission.label.receipt_type',
                "placeholder" => 'payroll::commission.placeholder.receipt_type',
                "rules" => '',
                "options" => function(){
                    return trans('payroll::commission.options.receipt_type');
                },
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'vat',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::commission.label.vat',
                "placeholder" => 'payroll::commission.placeholder.vat',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'type',
                "element" => 'radios',
                "type" => 'radios',
                "label" => 'payroll::commission.label.type',
                "placeholder" => 'payroll::commission.placeholder.type',
                "rules" => '',
                "options" => function(){
                    return trans('payroll::commission.options.type');
                },
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'description',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::commission.label.description',
                "placeholder" => 'payroll::commission.placeholder.description',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'cutoff_date',
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'payroll::commission.label.cutoff_date',
                "placeholder" => 'payroll::commission.placeholder.cutoff_date',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'receipt_date',
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'payroll::commission.label.receipt_date',
                "placeholder" => 'payroll::commission.placeholder.receipt_date',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'payroll/commission/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'payroll/commission/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'payroll/commission',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'payroll/commission',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'payroll/commission',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'payroll/commission',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'payroll::commission.label.created_at',
            'name' => 'payroll::commission.label.name',
            'status' => 'payroll::commission.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "payroll::commission.groups.main",
                'group' => "main.main",
                'title' => "payroll::commission.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "payroll::commission.groups.details",
                'group' => "main.details",
                'title' => "payroll::commission.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "payroll::commission.groups.images",
                'group' => "main.images",
                'title' => "payroll::commission.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "payroll::commission.groups.settings",
                'group' => "main.settings",
                'title' => "payroll::commission.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Bixo',
            'package' => 'Payroll',
            'module' => 'Commission',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Bixo\Payroll\Models\Commission::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'title' => 'Reject',
                            'button' => [
                                'cancel' > [
                                    'icon' > '',
                                    'varient' > '',
                                    'label' > 'Cancel'
                                ],
                                'submit' > [
                                    'icon' > '',
                                    'varient' > 'primary',
                                    'label' > 'Reject'
                                ]
                            ],
                            'fields' => [
                                'count' => [
                                    "element" => 'select',
                                    "type" => 'select',
                                    "label" => 'advert::advert.label.count',
                                    "placeholder" => 'advert::advert.placeholder.count',
                                    "options" => call_user_func(function () {
                                        return [
                                            1 => ['value' => 1, 'text' => 1],
                                            2 => ['value' => 2, 'text' => 2],
                                            3 => ['value' => 3, 'text' => 3],
                                            4 => ['value' => 4, 'text' => 4],
                                        ];
                                    }),
                                    "col" => "12",
                                ],
                                'comment' => [
                                    "element" => 'textarea',
                                    "type" => 'text',
                                    "required" => 'required',
                                    "label" => 'advert::advert.label.comment',
                                    "placeholder" => 'advert::advert.placeholder.comment',
                                    "col" => "12",
                                ],
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
        
    ];
