<?php


return  
    [
        'model' => [
            'model' => \Bixo\Payroll\Models\Payroll::class,
            'table' => 'bixo_payroll_payrolls',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['ref',  'date',  'cutoff_date',  'employee_id',  'certificate_no',  'commission',  'conveyancing',  'gross_salary',  'salary',  'days_worked',  'unpaid_leaves',  'additions',  'deductions',  'payment_mode',  'net_payment',  'payment_wps',  'payment_cheque',  'payment_cash',  'payment_others',  'balance',  'previous_balance',  'description',  'documents',  'notes',  'user_id',  'created_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'payroll/payroll',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "ref", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.ref', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "date", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.date', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "cutoff_date", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.cutoff_date', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "employee_id", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.employee_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "certificate_no", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.certificate_no', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "commission", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.commission', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "conveyancing", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.conveyancing', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "gross_salary", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.gross_salary', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "salary", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.salary', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "days_worked", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.days_worked', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "unpaid_leaves", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.unpaid_leaves', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "additions", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.additions', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "deductions", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.deductions', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payment_mode", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.payment_mode', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "net_payment", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.net_payment', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payment_wps", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.payment_wps', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payment_cheque", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.payment_cheque', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payment_cash", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.payment_cash', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "payment_others", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.payment_others', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "balance", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.balance', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "previous_balance", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.previous_balance', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "description", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.description', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "documents", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.documents', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "notes", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.notes', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "created_id", 
                "type" => "text", 
                "label" => 'payroll::payroll.label.created_id', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'ref',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.ref',
                "placeholder" => 'payroll::payroll.placeholder.ref',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'date',
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'payroll::payroll.label.date',
                "placeholder" => 'payroll::payroll.placeholder.date',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'cutoff_date',
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'payroll::payroll.label.cutoff_date',
                "placeholder" => 'payroll::payroll.placeholder.cutoff_date',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'employee_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::payroll.label.employee_id',
                "placeholder" => 'payroll::payroll.placeholder.employee_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'certificate_no',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.certificate_no',
                "placeholder" => 'payroll::payroll.placeholder.certificate_no',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'commission',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::payroll.label.commission',
                "placeholder" => 'payroll::payroll.placeholder.commission',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'conveyancing',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::payroll.label.conveyancing',
                "placeholder" => 'payroll::payroll.placeholder.conveyancing',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'gross_salary',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.gross_salary',
                "placeholder" => 'payroll::payroll.placeholder.gross_salary',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'salary',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.salary',
                "placeholder" => 'payroll::payroll.placeholder.salary',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'days_worked',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::payroll.label.days_worked',
                "placeholder" => 'payroll::payroll.placeholder.days_worked',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'unpaid_leaves',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::payroll.label.unpaid_leaves',
                "placeholder" => 'payroll::payroll.placeholder.unpaid_leaves',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'additions',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::payroll.label.additions',
                "placeholder" => 'payroll::payroll.placeholder.additions',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'deductions',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::payroll.label.deductions',
                "placeholder" => 'payroll::payroll.placeholder.deductions',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payment_mode',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.payment_mode',
                "placeholder" => 'payroll::payroll.placeholder.payment_mode',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'net_payment',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.net_payment',
                "placeholder" => 'payroll::payroll.placeholder.net_payment',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payment_wps',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.payment_wps',
                "placeholder" => 'payroll::payroll.placeholder.payment_wps',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payment_cheque',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.payment_cheque',
                "placeholder" => 'payroll::payroll.placeholder.payment_cheque',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payment_cash',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.payment_cash',
                "placeholder" => 'payroll::payroll.placeholder.payment_cash',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'payment_others',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.payment_others',
                "placeholder" => 'payroll::payroll.placeholder.payment_others',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'balance',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.balance',
                "placeholder" => 'payroll::payroll.placeholder.balance',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'previous_balance',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.previous_balance',
                "placeholder" => 'payroll::payroll.placeholder.previous_balance',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'description',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.description',
                "placeholder" => 'payroll::payroll.placeholder.description',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'documents',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.documents',
                "placeholder" => 'payroll::payroll.placeholder.documents',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'notes',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::payroll.label.notes',
                "placeholder" => 'payroll::payroll.placeholder.notes',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'created_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::payroll.label.created_id',
                "placeholder" => 'payroll::payroll.placeholder.created_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'payroll/payroll/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'payroll/payroll/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'payroll/payroll',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'payroll/payroll',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'payroll/payroll',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'payroll/payroll',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'payroll::payroll.label.created_at',
            'name' => 'payroll::payroll.label.name',
            'status' => 'payroll::payroll.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "payroll::payroll.groups.main",
                'group' => "main.main",
                'title' => "payroll::payroll.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "payroll::payroll.groups.details",
                'group' => "main.details",
                'title' => "payroll::payroll.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "payroll::payroll.groups.images",
                'group' => "main.images",
                'title' => "payroll::payroll.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "payroll::payroll.groups.settings",
                'group' => "main.settings",
                'title' => "payroll::payroll.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Bixo',
            'package' => 'Payroll',
            'module' => 'Payroll',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Bixo\Payroll\Models\Payroll::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'title' => 'Reject',
                            'button' => [
                                'cancel' > [
                                    'icon' > '',
                                    'varient' > '',
                                    'label' > 'Cancel'
                                ],
                                'submit' > [
                                    'icon' > '',
                                    'varient' > 'primary',
                                    'label' > 'Reject'
                                ]
                            ],
                            'fields' => [
                                'count' => [
                                    "element" => 'select',
                                    "type" => 'select',
                                    "label" => 'advert::advert.label.count',
                                    "placeholder" => 'advert::advert.placeholder.count',
                                    "options" => call_user_func(function () {
                                        return [
                                            1 => ['value' => 1, 'text' => 1],
                                            2 => ['value' => 2, 'text' => 2],
                                            3 => ['value' => 3, 'text' => 3],
                                            4 => ['value' => 4, 'text' => 4],
                                        ];
                                    }),
                                    "col" => "12",
                                ],
                                'comment' => [
                                    "element" => 'textarea',
                                    "type" => 'text',
                                    "required" => 'required',
                                    "label" => 'advert::advert.label.comment',
                                    "placeholder" => 'advert::advert.placeholder.comment',
                                    "col" => "12",
                                ],
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
        
    ];
