<?php


return  
    [
        'model' => [
            'model' => \Bixo\Payroll\Models\Salary::class,
            'table' => 'bixo_payroll_salaries',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['organization_id',  'employee_id',  'salary',  'commission_per',  'type',  'date',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'payroll/salary',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "organization_id", 
                "type" => "text", 
                "label" => 'payroll::salary.label.organization_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "employee_id", 
                "type" => "text", 
                "label" => 'payroll::salary.label.employee_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "salary", 
                "type" => "text", 
                "label" => 'payroll::salary.label.salary', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "commission_per", 
                "type" => "text", 
                "label" => 'payroll::salary.label.commission_per', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "type", 
                "type" => "text", 
                "label" => 'payroll::salary.label.type', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "date", 
                "type" => "text", 
                "label" => 'payroll::salary.label.date', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'organization_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::salary.label.organization_id',
                "placeholder" => 'payroll::salary.placeholder.organization_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'employee_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::salary.label.employee_id',
                "placeholder" => 'payroll::salary.placeholder.employee_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'salary',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::salary.label.salary',
                "placeholder" => 'payroll::salary.placeholder.salary',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'commission_per',
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => 'payroll::salary.label.commission_per',
                "placeholder" => 'payroll::salary.placeholder.commission_per',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'type',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::salary.label.type',
                "placeholder" => 'payroll::salary.placeholder.type',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'date',
                "element" => 'date_time_picker',
                "type" => 'date_time_picker',
                "label" => 'payroll::salary.label.date',
                "placeholder" => 'payroll::salary.placeholder.date',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'payroll/salary/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'payroll/salary/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'payroll/salary',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'payroll/salary',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'payroll/salary',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'payroll/salary',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'payroll::salary.label.created_at',
            'name' => 'payroll::salary.label.name',
            'status' => 'payroll::salary.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "payroll::salary.groups.main",
                'group' => "main.main",
                'title' => "payroll::salary.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "payroll::salary.groups.details",
                'group' => "main.details",
                'title' => "payroll::salary.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "payroll::salary.groups.images",
                'group' => "main.images",
                'title' => "payroll::salary.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "payroll::salary.groups.settings",
                'group' => "main.settings",
                'title' => "payroll::salary.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Bixo',
            'package' => 'Payroll',
            'module' => 'Salary',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Bixo\Payroll\Models\Salary::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'title' => 'Reject',
                            'button' => [
                                'cancel' > [
                                    'icon' > '',
                                    'varient' > '',
                                    'label' > 'Cancel'
                                ],
                                'submit' > [
                                    'icon' > '',
                                    'varient' > 'primary',
                                    'label' > 'Reject'
                                ]
                            ],
                            'fields' => [
                                'count' => [
                                    "element" => 'select',
                                    "type" => 'select',
                                    "label" => 'advert::advert.label.count',
                                    "placeholder" => 'advert::advert.placeholder.count',
                                    "options" => call_user_func(function () {
                                        return [
                                            1 => ['value' => 1, 'text' => 1],
                                            2 => ['value' => 2, 'text' => 2],
                                            3 => ['value' => 3, 'text' => 3],
                                            4 => ['value' => 4, 'text' => 4],
                                        ];
                                    }),
                                    "col" => "12",
                                ],
                                'comment' => [
                                    "element" => 'textarea',
                                    "type" => 'text',
                                    "required" => 'required',
                                    "label" => 'advert::advert.label.comment',
                                    "placeholder" => 'advert::advert.placeholder.comment',
                                    "col" => "12",
                                ],
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
        
    ];
