<?php


return  
    [
        'model' => [
            'model' => \Bixo\Payroll\Models\Slab::class,
            'table' => 'bixo_payroll_slabs',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['organization_id',  'json',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'payroll/slab',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "organization_id", 
                "type" => "text", 
                "label" => 'payroll::slab.label.organization_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "json", 
                "type" => "text", 
                "label" => 'payroll::slab.label.json', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'organization_id',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'payroll::slab.label.organization_id',
                "placeholder" => 'payroll::slab.placeholder.organization_id',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'json',
                "element" => 'text',
                "type" => 'text',
                "label" => 'payroll::slab.label.json',
                "placeholder" => 'payroll::slab.placeholder.json',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'payroll/slab/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'payroll/slab/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'payroll/slab',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'payroll/slab',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'payroll/slab',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'payroll/slab',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'payroll::slab.label.created_at',
            'name' => 'payroll::slab.label.name',
            'status' => 'payroll::slab.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "payroll::slab.groups.main",
                'group' => "main.main",
                'title' => "payroll::slab.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "payroll::slab.groups.details",
                'group' => "main.details",
                'title' => "payroll::slab.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "payroll::slab.groups.images",
                'group' => "main.images",
                'title' => "payroll::slab.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "payroll::slab.groups.settings",
                'group' => "main.settings",
                'title' => "payroll::slab.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Bixo',
            'package' => 'Payroll',
            'module' => 'Slab',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Bixo\Payroll\Models\Slab::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'title' => 'Reject',
                            'button' => [
                                'cancel' > [
                                    'icon' > '',
                                    'varient' > '',
                                    'label' > 'Cancel'
                                ],
                                'submit' > [
                                    'icon' > '',
                                    'varient' > 'primary',
                                    'label' > 'Reject'
                                ]
                            ],
                            'fields' => [
                                'count' => [
                                    "element" => 'select',
                                    "type" => 'select',
                                    "label" => 'advert::advert.label.count',
                                    "placeholder" => 'advert::advert.placeholder.count',
                                    "options" => call_user_func(function () {
                                        return [
                                            1 => ['value' => 1, 'text' => 1],
                                            2 => ['value' => 2, 'text' => 2],
                                            3 => ['value' => 3, 'text' => 3],
                                            4 => ['value' => 4, 'text' => 4],
                                        ];
                                    }),
                                    "col" => "12",
                                ],
                                'comment' => [
                                    "element" => 'textarea',
                                    "type" => 'text',
                                    "required" => 'required',
                                    "label" => 'advert::advert.label.comment',
                                    "placeholder" => 'advert::advert.placeholder.comment',
                                    "col" => "12",
                                ],
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
        
    ];
