<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBixoPayrollAdjustmentsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bixo_payroll_adjustments
         */
        Schema::create('bixo_payroll_adjustments', function ($table) {
            $table->increments('id');
            $table->string('ref', 30)->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('payroll_id')->nullable();
            $table->integer('request_id')->nullable();
            $table->integer('related_id')->nullable();
            $table->tinyInteger('payroll_show')->nullable();
            $table->date('payment_date')->nullable();
            $table->string('type', 100)->nullable();
            $table->string('type_other', 50)->nullable();
            $table->decimal('addition', 12,2)->nullable();
            $table->decimal('deduction', 12,2)->nullable();
            $table->string('status', 100)->nullable();
            $table->text('description')->nullable();
            $table->text('notes')->nullable();
            $table->text('documents')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 50)->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bixo_payroll_adjustments');
    }
}
