<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBixoPayrollCommissionsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bixo_payroll_commissions
         */
        Schema::create('bixo_payroll_commissions', function ($table) {
            $table->increments('id');
            $table->integer('agent_id')->nullable();
            $table->integer('deal_id')->nullable();
            $table->integer('payroll_id')->nullable();
            $table->integer('receipt_id')->nullable();
            $table->decimal('split', 5,2)->nullable();
            $table->decimal('agent_per', 5,2)->nullable();
            $table->decimal('agent_com', 12,3)->nullable();
            $table->decimal('company_com', 12,3)->nullable();
            $table->decimal('slab_amount', 12,2)->nullable();
            $table->decimal('additional_per', 5,2)->nullable();
            $table->decimal('additional_com', 12,3)->nullable();
            $table->decimal('receipt', 12,3)->nullable();
            $table->enum('receipt_type', ['Yes', 'No'])->nullable();
            $table->decimal('vat', 12,3)->nullable();
            $table->enum('type', ['Yes', 'No'])->nullable();
            $table->text('description')->nullable();
            $table->date('cutoff_date')->nullable();
            $table->date('receipt_date')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 30)->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bixo_payroll_commissions');
    }
}
