<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBixoPayrollPayrollsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bixo_payroll_payrolls
         */
        Schema::create('bixo_payroll_payrolls', function ($table) {
            $table->increments('id');
            $table->string('ref', 30)->nullable();
            $table->date('date')->nullable();
            $table->date('cutoff_date')->nullable();
            $table->integer('employee_id')->nullable();
            $table->string('certificate_no', 100)->nullable();
            $table->decimal('commission', 10,2)->nullable();
            $table->decimal('conveyancing', 12,2)->nullable();
            $table->string('gross_salary', 250)->nullable();
            $table->string('salary', 250)->nullable();
            $table->integer('days_worked')->nullable();
            $table->decimal('unpaid_leaves', 4,2)->nullable();
            $table->integer('additions')->nullable();
            $table->integer('deductions')->nullable();
            $table->string('payment_mode', 60)->nullable();
            $table->string('net_payment', 250)->nullable();
            $table->string('payment_wps', 250)->nullable();
            $table->string('payment_cheque', 250)->nullable();
            $table->string('payment_cash', 250)->nullable();
            $table->string('payment_others', 250)->nullable();
            $table->string('balance', 250)->nullable();
            $table->string('previous_balance', 250)->nullable();
            $table->text('description')->nullable();
            $table->text('documents')->nullable();
            $table->text('notes')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('created_id')->nullable();
            $table->string('user_type', 50)->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bixo_payroll_payrolls');
    }
}
