<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBixoPayrollSalariesTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bixo_payroll_salaries
         */
        Schema::create('bixo_payroll_salaries', function ($table) {
            $table->increments('id');
            $table->integer('organization_id')->nullable();
            $table->integer('employee_id')->nullable();
            $table->string('salary', 50)->nullable();
            $table->decimal('commission_per', 12,2)->nullable();
            $table->string('type', 50)->nullable();
            $table->dateTime('date')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 20)->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bixo_payroll_salaries');
    }
}
