<?php

namespace Bixo\Payroll\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class AdjustmentTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_payroll_adjustments')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.payroll.adjustment.view',
                'name'      => 'View Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.create',
                'name'      => 'Create Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.edit',
                'name'      => 'Update Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.delete',
                'name'      => 'Delete Adjustment',
            ],
            
                        [
                'slug'      => 'bixo.payroll.adjustment.verify',
                'name'      => 'Verify Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.approve',
                'name'      => 'Approve Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.publish',
                'name'      => 'Publish Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.unpublish',
                'name'      => 'Unpublish Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.cancel',
                'name'      => 'Cancel Adjustment',
            ],
            [
                'slug'      => 'bixo.payroll.adjustment.archive',
                'name'      => 'Archive Adjustment',
            ],
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/payroll/adjustment',
                'name'        => 'Adjustment',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/payroll/adjustment',
                'name'        => 'Adjustment',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'adjustment',
                'name'        => 'Adjustment',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Payroll',
                'module'    => 'Adjustment',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.payroll.adjustment.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
