<?php

namespace Bixo\Payroll\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class CommissionTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_payroll_commissions')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.payroll.commission.view',
                'name'      => 'View Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.create',
                'name'      => 'Create Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.edit',
                'name'      => 'Update Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.delete',
                'name'      => 'Delete Commission',
            ],
            
                        [
                'slug'      => 'bixo.payroll.commission.verify',
                'name'      => 'Verify Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.approve',
                'name'      => 'Approve Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.publish',
                'name'      => 'Publish Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.unpublish',
                'name'      => 'Unpublish Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.cancel',
                'name'      => 'Cancel Commission',
            ],
            [
                'slug'      => 'bixo.payroll.commission.archive',
                'name'      => 'Archive Commission',
            ],
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/payroll/commission',
                'name'        => 'Commission',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/payroll/commission',
                'name'        => 'Commission',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'commission',
                'name'        => 'Commission',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Payroll',
                'module'    => 'Commission',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.payroll.commission.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
