<?php

namespace Bixo\Payroll\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class SalaryTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_payroll_salaries')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.payroll.salary.view',
                'name'      => 'View Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.create',
                'name'      => 'Create Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.edit',
                'name'      => 'Update Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.delete',
                'name'      => 'Delete Salary',
            ],
            
                        [
                'slug'      => 'bixo.payroll.salary.verify',
                'name'      => 'Verify Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.approve',
                'name'      => 'Approve Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.publish',
                'name'      => 'Publish Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.unpublish',
                'name'      => 'Unpublish Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.cancel',
                'name'      => 'Cancel Salary',
            ],
            [
                'slug'      => 'bixo.payroll.salary.archive',
                'name'      => 'Archive Salary',
            ],
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/payroll/salary',
                'name'        => 'Salary',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/payroll/salary',
                'name'        => 'Salary',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'salary',
                'name'        => 'Salary',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Payroll',
                'module'    => 'Salary',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.payroll.salary.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
