<?php

namespace Bixo\Payroll\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class SlabTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_payroll_slabs')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.payroll.slab.view',
                'name'      => 'View Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.create',
                'name'      => 'Create Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.edit',
                'name'      => 'Update Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.delete',
                'name'      => 'Delete Slab',
            ],
            
                        [
                'slug'      => 'bixo.payroll.slab.verify',
                'name'      => 'Verify Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.approve',
                'name'      => 'Approve Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.publish',
                'name'      => 'Publish Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.unpublish',
                'name'      => 'Unpublish Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.cancel',
                'name'      => 'Cancel Slab',
            ],
            [
                'slug'      => 'bixo.payroll.slab.archive',
                'name'      => 'Archive Slab',
            ],
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/payroll/slab',
                'name'        => 'Slab',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/payroll/slab',
                'name'        => 'Slab',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'slab',
                'name'        => 'Slab',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Payroll',
                'module'    => 'Slab',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.payroll.slab.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
