# Installation

The instructions below will help you to properly installand run the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/bixo/payroll/`

## Composer

Add the below entries in the `composer.json`.


```json

...
     "repositories": {
        ...

        {
            "type": "path",
            "url": "packages/bixo/payroll"
        }

        ...
    },
...

```
Then run `composer require bixo/payroll`


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Bixo\\Payroll\\Seeders\\PayrollTableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Bixo\Payroll\Providers\PayrollServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Bixo\Payroll\Providers\PayrollServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Bixo\Payroll\Providers\PayrollServiceProvider" --tag="view"
```

## URLs and APIs

### Web Urls

* Admin
```
    http://path-to-route-folder/admin/payroll/{modulename}
```

* User
```
    http://path-to-route-folder/user/payroll/{modulename}
```

* Public
```
    http://path-to-route-folder/payrolls
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/payroll/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/payroll/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/payroll/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/payroll/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/payroll/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/payroll/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/payroll/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/payroll/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/payroll/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/payroll/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/payroll/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
