<?php

// Web routes  for payroll.

include('routes.php');


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            include('routes.php');

        }
    );
}

// Workflow routes for payroll

Route::prefix('{guard}/payroll')->group(function () {

    Route::get('/workflow/{payroll}/{user}', 'PayrollWorkflowController@get')
        ->name('bixo.payroll.workflow');
    Route::post('/workflow/{payroll}/{user}', 'PayrollWorkflowController@post');


});


// Workflow routes for commission

Route::prefix('{guard}/commission')->group(function () {

    Route::get('/workflow/{commission}/{user}', 'CommissionWorkflowController@get')
        ->name('bixo.payroll.workflow');
    Route::post('/workflow/{commission}/{user}', 'CommissionWorkflowController@post');


});


// Workflow routes for adjustment

Route::prefix('{guard}/adjustment')->group(function () {

    Route::get('/workflow/{adjustment}/{user}', 'AdjustmentWorkflowController@get')
        ->name('bixo.payroll.workflow');
    Route::post('/workflow/{adjustment}/{user}', 'AdjustmentWorkflowController@post');


});


// Workflow routes for salary

Route::prefix('{guard}/salary')->group(function () {

    Route::get('/workflow/{salary}/{user}', 'SalaryWorkflowController@get')
        ->name('bixo.payroll.workflow');
    Route::post('/workflow/{salary}/{user}', 'SalaryWorkflowController@post');


});


// Workflow routes for slab

Route::prefix('{guard}/slab')->group(function () {

    Route::get('/workflow/{slab}/{user}', 'SlabWorkflowController@get')
        ->name('bixo.payroll.workflow');
    Route::post('/workflow/{slab}/{user}', 'SlabWorkflowController@post');


});

