<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Payroll\Models\Adjustment;


class AdjustmentAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.payroll.adjustment';
    protected $eventClass = \Bixo\Payroll\Events\AdjustmentAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Adjustment $adjustment, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $adjustment;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Adjustment $adjustment, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $adjustment = $adjustment->create($attributes);
        return $adjustment;
    }

    public function update(Adjustment $adjustment, array $request)
    {
        $attributes = $request;
        $adjustment->update($attributes);
        return $adjustment;
    }

    public function destroy(Adjustment $adjustment, array $request)
    {
        $adjustment->delete();
        return $adjustment;
    }

    public function copy(Adjustment $adjustment, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $adjustment = $adjustment->replicate();
            $adjustment->created_at = Carbon::now();
            $adjustment->save();
            return $adjustment;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $adjustment->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $adjustment;
    }


}
