<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Payroll\Models\Commission;


class CommissionAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.payroll.commission';
    protected $eventClass = \Bixo\Payroll\Events\CommissionAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Commission $commission, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $commission;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Commission $commission, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $commission = $commission->create($attributes);
        return $commission;
    }

    public function update(Commission $commission, array $request)
    {
        $attributes = $request;
        $commission->update($attributes);
        return $commission;
    }

    public function destroy(Commission $commission, array $request)
    {
        $commission->delete();
        return $commission;
    }

    public function copy(Commission $commission, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $commission = $commission->replicate();
            $commission->created_at = Carbon::now();
            $commission->save();
            return $commission;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $commission->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $commission;
    }


}
