<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Support\Str;
use Bixo\Payroll\Models\Commission;
use Bixo\Payroll\Scopes\CommissionResourceScope;
use Litepie\Actions\Concerns\AsAction;
use Litepie\Actions\Traits\LogsActions;
use Litepie\Database\RequestScope;

class CommissionActions
{
    use AsAction;
    use LogsActions;
    
    protected $model;
    protected $namespace = 'bixo.payroll.commission';
    protected $eventClass = \Bixo\Payroll\Events\CommissionAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, array $request)
    {
        $this->model = app(Commission::class);
        $this->action = $action;
        $this->request = $request;
        $this->function = Str::camel($action);

        $function = Str::camel($action);

        $this->dispatchActionBeforeEvent();
        $data = $this->$function($request);
        $this->dispatchActionAfterEvent();

        $this->logsAction();
        return $data;

    }

    public function paginate(array $request)
    {
        $pageLimit = isset($request['pageLimit']) ?: config('database.pagination.limit');
        $commission = $this->model
            ->pushScope(new RequestScope())
            ->pushScope(new CommissionResourceScope())
            ->paginate($pageLimit);

        return $commission;
    }

    public function simplePaginate(array $request)
    {
        $pageLimit = isset($request['pageLimit']) ?: config('database.pagination.limit');
        $commission = $this->model
            ->pushScope(new RequestScope())
            ->pushScope(new CommissionResourceScope())
            ->simplePaginate($pageLimit);

        return $commission;
    }

    function empty(array $request) {
        return $this->model->forceDelete();
    }

    function restore(array $request) {
        return $this->model->restore();
    }

    public function delete(array $request)
    {
        $ids = $request['ids'];
        $ids = collect($ids)->map(function ($id) {
            return hashids_decode($id);
        });
        return $this->model->whereIn('id', $ids)->delete();
    }

    public function options(array $request)
    {
        return $this->model
            ->pushScope(new RequestScope())
            ->pushScope(new CommissionResourceScope())
            ->take(30)->get()
            ->map(function ($row) {
                return [
                    'key' => $row->id,
                    'value' => $row->id,
                    'text' => $row->name,
                ];
            })->toArray();
    }
}
