<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Payroll\Models\Payroll;


class PayrollAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.payroll.payroll';
    protected $eventClass = \Bixo\Payroll\Events\PayrollAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Payroll $payroll, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $payroll;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Payroll $payroll, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $payroll = $payroll->create($attributes);
        return $payroll;
    }

    public function update(Payroll $payroll, array $request)
    {
        $attributes = $request;
        $payroll->update($attributes);
        return $payroll;
    }

    public function destroy(Payroll $payroll, array $request)
    {
        $payroll->delete();
        return $payroll;
    }

    public function copy(Payroll $payroll, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $payroll = $payroll->replicate();
            $payroll->created_at = Carbon::now();
            $payroll->save();
            return $payroll;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $payroll->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $payroll;
    }


}
