<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Http\Request;
use Bixo\Payroll\Models\Payroll;
use Litepie\Actions\Concerns\AsAction;
use Illuminate\Support\Str;

class PayrollWorkflow
{
    use AsAction;
    
    private $model;
    private $namespace = 'bixo.payroll.$payroll';
    private $transition;
    protected $eventClass = \Bixo\Payroll\Events\PayrollWorkflow::class;
    private $function;
    private $request;

    public function handle(string $transition, Payroll $payroll, array $request = [])
    {
        $this->model = $payroll;
        $this->request = $request;
        $this->transition = $transition;
        $this->function = Str::camel($transition);
        $this->executeWorkflow();
        return $this->model;
    }

    public function submit()
    {
        $this->model->status = 'Pending';
        $this->model->save();
        return $this->model;
    }

    public function approve()
    {
        $this->model->status = 'Approved';
        $this->model->save();
        return $this->model;
    }

    public function reject()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }

    public function publish()
    {
        $this->model->status = 'Published';
        $this->model->save();
        return $this->model;
    }

    public function unpublish()
    {
        $this->model->status = 'Unpublished';
        $this->model->save();
        return $this->model;
    }

    public function archive()
    {
        $this->model->status = 'Archived';
        $this->model->save();
        return $this->model;
    }

    public function unarchive()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }
}
