<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Payroll\Models\Salary;


class SalaryAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.payroll.salary';
    protected $eventClass = \Bixo\Payroll\Events\SalaryAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Salary $salary, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $salary;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Salary $salary, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $salary = $salary->create($attributes);
        return $salary;
    }

    public function update(Salary $salary, array $request)
    {
        $attributes = $request;
        $salary->update($attributes);
        return $salary;
    }

    public function destroy(Salary $salary, array $request)
    {
        $salary->delete();
        return $salary;
    }

    public function copy(Salary $salary, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $salary = $salary->replicate();
            $salary->created_at = Carbon::now();
            $salary->save();
            return $salary;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $salary->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $salary;
    }


}
