<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Http\Request;
use Bixo\Payroll\Models\Salary;
use Litepie\Actions\Concerns\AsAction;
use Illuminate\Support\Str;

class SalaryWorkflow
{
    use AsAction;
    
    private $model;
    private $namespace = 'bixo.payroll.$salary';
    private $transition;
    protected $eventClass = \Bixo\Payroll\Events\SalaryWorkflow::class;
    private $function;
    private $request;

    public function handle(string $transition, Salary $salary, array $request = [])
    {
        $this->model = $salary;
        $this->request = $request;
        $this->transition = $transition;
        $this->function = Str::camel($transition);
        $this->executeWorkflow();
        return $this->model;
    }

    public function submit()
    {
        $this->model->status = 'Pending';
        $this->model->save();
        return $this->model;
    }

    public function approve()
    {
        $this->model->status = 'Approved';
        $this->model->save();
        return $this->model;
    }

    public function reject()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }

    public function publish()
    {
        $this->model->status = 'Published';
        $this->model->save();
        return $this->model;
    }

    public function unpublish()
    {
        $this->model->status = 'Unpublished';
        $this->model->save();
        return $this->model;
    }

    public function archive()
    {
        $this->model->status = 'Archived';
        $this->model->save();
        return $this->model;
    }

    public function unarchive()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }
}
