<?php

namespace Bixo\Payroll\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Payroll\Models\Slab;


class SlabAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.payroll.slab';
    protected $eventClass = \Bixo\Payroll\Events\SlabAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Slab $slab, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $slab;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Slab $slab, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $slab = $slab->create($attributes);
        return $slab;
    }

    public function update(Slab $slab, array $request)
    {
        $attributes = $request;
        $slab->update($attributes);
        return $slab;
    }

    public function destroy(Slab $slab, array $request)
    {
        $slab->delete();
        return $slab;
    }

    public function copy(Slab $slab, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $slab = $slab->replicate();
            $slab->created_at = Carbon::now();
            $slab->save();
            return $slab;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $slab->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $slab;
    }


}
