<?php

namespace Bixo\Payroll\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Bixo\Payroll\Models\Commission;

class CommissionWorkflow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */
    public function __construct(
        public string $transition,
        public Commission $commission,
        public array $request = [],
        public string $when = 'after'
    ) {
    }
}
