<?php

namespace Bixo\Payroll\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Bixo\Payroll\Models\Salary;

class SalaryWorkflow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */
    public function __construct(
        public string $transition,
        public Salary $salary,
        public array $request = [],
        public string $when = 'after'
    ) {
    }
}
