<?php

namespace Bixo\Payroll\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CommissionResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('payroll/commission') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'slug' => $this->slug,
            'agent_id' => $this->agent_id,
            'deal_id' => $this->deal_id,
            'payroll_id' => $this->payroll_id,
            'receipt_id' => $this->receipt_id,
            'split' => $this->split,
            'agent_per' => $this->agent_per,
            'agent_com' => $this->agent_com,
            'company_com' => $this->company_com,
            'slab_amount' => $this->slab_amount,
            'additional_per' => $this->additional_per,
            'additional_com' => $this->additional_com,
            'receipt' => $this->receipt,
            'receipt_type' => $this->receipt_type,
            'vat' => $this->vat,
            'type' => $this->type,
            'description' => $this->description,
            'cutoff_date' => $this->cutoff_date,
            'receipt_date' => $this->receipt_date,
            'user_id' => $this->user_id,
            'user_type' => $this->user_type,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param     \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get the workflows for the resource.
     *
     * @return array
     */
    private function workflows()
    {
        $arr = [];
                $workflow = $this->resource->workflow();
        foreach ($workflow->transitions($this) as $key => $transition) {
            $name = $transition->getName();
            $arr[$key]['url'] = guard_url('payroll/commission/workflow/' . $this->getRouteKey() . '/' . $name);
            $arr[$key]['name'] = $name;
            $arr[$key]['key'] = $name;
            $arr[$key]['form'] = $workflow->form($transition);
            $arr[$key]['label'] = trans('payroll::commission.workflow.' . $name);
        }
                return $arr;

    }
    
    /**
     * Get the actions for the resource.
     *
     * @return array
     */
    private function actions()
    {

        $arr = [];
        
        return $arr;
    }
}
