<?php

namespace Bixo\Payroll\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PayrollResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('payroll/payroll') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'slug' => $this->slug,
            'ref' => $this->ref,
            'date' => $this->date,
            'cutoff_date' => $this->cutoff_date,
            'employee_id' => $this->employee_id,
            'certificate_no' => $this->certificate_no,
            'commission' => $this->commission,
            'conveyancing' => $this->conveyancing,
            'gross_salary' => $this->gross_salary,
            'salary' => $this->salary,
            'days_worked' => $this->days_worked,
            'unpaid_leaves' => $this->unpaid_leaves,
            'additions' => $this->additions,
            'deductions' => $this->deductions,
            'payment_mode' => $this->payment_mode,
            'net_payment' => $this->net_payment,
            'payment_wps' => $this->payment_wps,
            'payment_cheque' => $this->payment_cheque,
            'payment_cash' => $this->payment_cash,
            'payment_others' => $this->payment_others,
            'balance' => $this->balance,
            'previous_balance' => $this->previous_balance,
            'description' => $this->description,
            'documents' => $this->documents,
            'notes' => $this->notes,
            'user_id' => $this->user_id,
            'created_id' => $this->created_id,
            'user_type' => $this->user_type,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param     \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get the workflows for the resource.
     *
     * @return array
     */
    private function workflows()
    {
        $arr = [];
                $workflow = $this->resource->workflow();
        foreach ($workflow->transitions($this) as $key => $transition) {
            $name = $transition->getName();
            $arr[$key]['url'] = guard_url('payroll/payroll/workflow/' . $this->getRouteKey() . '/' . $name);
            $arr[$key]['name'] = $name;
            $arr[$key]['key'] = $name;
            $arr[$key]['form'] = $workflow->form($transition);
            $arr[$key]['label'] = trans('payroll::payroll.workflow.' . $name);
        }
                return $arr;

    }
    
    /**
     * Get the actions for the resource.
     *
     * @return array
     */
    private function actions()
    {

        $arr = [];
        
        return $arr;
    }
}
